(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 8.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       157,          7]
NotebookDataLength[    147631,       3398]
NotebookOptionsPosition[    146039,       3337]
NotebookOutlinePosition[    146414,       3353]
CellTagsIndexPosition[    146371,       3350]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData["\[IndentingNewLine]"], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Button", "[", 
   RowBox[{"\"\<Database Initialization\>\"", ",", 
    RowBox[{
     RowBox[{"Clear", "[", 
      RowBox[{
      "baza", ",", "cer", ",", "bazaSA", ",", "bazaOAc", ",", "bazadNA"}], 
      "]"}], ";", "\[IndentingNewLine]", 
     RowBox[{"baza0", "=", 
      RowBox[{"Import", "[", 
       RowBox[{"\"\<baza-string.txt\>\"", ",", " ", "\"\<Data\>\"", ",", 
        RowBox[{"Path", "\[Rule]", 
         RowBox[{"NotebookDirectory", "[", "]"}]}]}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"cer", "=", 
      RowBox[{"Import", "[", 
       RowBox[{"\"\<ceramidi.txt\>\"", ",", " ", "\"\<Table\>\"", ",", " ", 
        RowBox[{"Path", "\[Rule]", 
         RowBox[{"NotebookDirectory", "[", "]"}]}]}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"bazaSA", "=", 
      RowBox[{"Import", "[", 
       RowBox[{"\"\<baza-SA.txt\>\"", ",", " ", "\"\<Table\>\"", ",", 
        RowBox[{"Path", "\[Rule]", 
         RowBox[{"NotebookDirectory", "[", "]"}]}]}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"bazaOAc", "=", 
      RowBox[{"Import", "[", 
       RowBox[{"\"\<baza-OAc.txt\>\"", ",", " ", "\"\<Table\>\"", ",", 
        RowBox[{"Path", "\[Rule]", 
         RowBox[{"NotebookDirectory", "[", "]"}]}]}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"bazadNA", "=", 
      RowBox[{"Import", "[", 
       RowBox[{"\"\<baza-dNA.txt\>\"", ",", " ", "\"\<Table\>\"", ",", 
        RowBox[{"Path", "\[Rule]", 
         RowBox[{"NotebookDirectory", "[", "]"}]}]}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"Tole", "=", "0.5"}], ";", "\[IndentingNewLine]", 
     RowBox[{"ToleMSMS", "=", "0.8"}], ";", "\[IndentingNewLine]", 
     RowBox[{"CreateDialog", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"TextCell", "[", "\"\<Initialization completed\>\"", "]"}], 
        ",", 
        RowBox[{"DefaultButton", "[", "]"}]}], "}"}], "]"}], ";"}], 
    "\[IndentingNewLine]", ",", 
    RowBox[{"Method", "\[Rule]", "\"\<Queued\>\""}]}], "]"}], 
  "\[IndentingNewLine]"}]], "Input",
 Editable->False,
 CellOpen->False],

Cell[BoxData[
 ButtonBox["\<\"Database Initialization\"\>",
  Appearance->Automatic,
  ButtonFunction:>(
   Clear[$CellContext`baza, $CellContext`cer, $CellContext`bazaSA, \
$CellContext`bazaOAc, $CellContext`bazadNA]; $CellContext`baza0 = 
    Import["baza-string.txt", "Data", Path -> 
      NotebookDirectory[]]; $CellContext`cer = 
    Import["ceramidi.txt", "Table", Path -> 
      NotebookDirectory[]]; $CellContext`bazaSA = 
    Import["baza-SA.txt", "Table", Path -> 
      NotebookDirectory[]]; $CellContext`bazaOAc = 
    Import["baza-OAc.txt", "Table", Path -> 
      NotebookDirectory[]]; $CellContext`bazadNA = 
    Import["baza-dNA.txt", "Table", Path -> 
      NotebookDirectory[]]; $CellContext`Tole = 0.5; $CellContext`ToleMSMS = 
    0.8; CreateDialog[{
      TextCell["Initialization completed"], 
      DefaultButton[]}]; Null),
  Evaluator->Automatic,
  Method->"Queued"]], "Output"]
}, {2}]],

Cell[BoxData[""], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Column", "[", 
  RowBox[{"{", 
   RowBox[{"Column", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"\"\<MS tolerance:\[PlusMinus]\>\"", ",", 
       RowBox[{"Manipulate", "[", 
        RowBox[{
         RowBox[{"Tole", "=", "MS"}], ",", 
         RowBox[{"{", 
          RowBox[{"MS", ",", "0", ",", "1", ",", "0.1"}], "}"}], ",", 
         RowBox[{"ControlPlacement", "\[Rule]", "Left"}]}], "]"}], ",", 
       "\"\<MS/MS tolerance:\[PlusMinus]\>\"", ",", 
       RowBox[{"Manipulate", "[", 
        RowBox[{
         RowBox[{"ToleMSMS", "=", "MSMS"}], ",", 
         RowBox[{"{", 
          RowBox[{"MSMS", ",", "0", ",", "1.5", ",", "0.1"}], "}"}], ",", 
         RowBox[{"ControlPlacement", "\[Rule]", "Left"}]}], "]"}]}], "}"}], 
     ",", "Center"}], "]"}], "}"}], "]"}]], "Input",
 Editable->False,
 CellOpen->False],

Cell[BoxData[
 TagBox[GridBox[{
    {
     TagBox[GridBox[{
        {"\<\"MS tolerance:\[PlusMinus]\"\>"},
        {
         TagBox[
          StyleBox[
           
           DynamicModuleBox[{$CellContext`MS$$ = 0.5, Typeset`show$$ = True, 
            Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
            Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
            "\"untitled\"", Typeset`specs$$ = {{
              Hold[$CellContext`MS$$], 0, 1, 0.1}}, Typeset`size$$ = {
            21., {0., 8.}}, Typeset`update$$ = 0, Typeset`initDone$$, 
            Typeset`skipInitDone$$ = True, $CellContext`MS$1291$$ = 0}, 
            
            DynamicBox[Manipulate`ManipulateBoxes[
             1, StandardForm, "Variables" :> {$CellContext`MS$$ = 0}, 
              "ControllerVariables" :> {
                Hold[$CellContext`MS$$, $CellContext`MS$1291$$, 0]}, 
              "OtherVariables" :> {
               Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$,
                 Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
                Typeset`specs$$, Typeset`size$$, Typeset`update$$, 
                Typeset`initDone$$, Typeset`skipInitDone$$}, 
              "Body" :> ($CellContext`Tole = $CellContext`MS$$), 
              "Specifications" :> {{$CellContext`MS$$, 0, 1, 0.1}}, 
              "Options" :> {ControlPlacement -> Left}, "DefaultOptions" :> {}],
             ImageSizeCache->{309., {36., 41.}},
             SingleEvaluation->True],
            Deinitialization:>None,
            DynamicModuleValues:>{},
            SynchronousInitialization->True,
            UnsavedVariables:>{Typeset`initDone$$},
            UntrackedVariables:>{Typeset`size$$}], "Manipulate",
           Deployed->True,
           StripOnInput->False],
          Manipulate`InterpretManipulate[1]]},
        {"\<\"MS/MS tolerance:\[PlusMinus]\"\>"},
        {
         TagBox[
          StyleBox[
           
           DynamicModuleBox[{$CellContext`MSMS$$ = 0.8, Typeset`show$$ = True,
             Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
            Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
            "\"untitled\"", Typeset`specs$$ = {{
              Hold[$CellContext`MSMS$$], 0, 1.5, 0.1}}, Typeset`size$$ = {
            21., {0., 8.}}, Typeset`update$$ = 0, Typeset`initDone$$, 
            Typeset`skipInitDone$$ = True, $CellContext`MSMS$1308$$ = 0}, 
            
            DynamicBox[Manipulate`ManipulateBoxes[
             1, StandardForm, "Variables" :> {$CellContext`MSMS$$ = 0}, 
              "ControllerVariables" :> {
                Hold[$CellContext`MSMS$$, $CellContext`MSMS$1308$$, 0]}, 
              "OtherVariables" :> {
               Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$,
                 Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
                Typeset`specs$$, Typeset`size$$, Typeset`update$$, 
                Typeset`initDone$$, Typeset`skipInitDone$$}, 
              "Body" :> ($CellContext`ToleMSMS = $CellContext`MSMS$$), 
              "Specifications" :> {{$CellContext`MSMS$$, 0, 1.5, 0.1}}, 
              "Options" :> {ControlPlacement -> Left}, "DefaultOptions" :> {}],
             ImageSizeCache->{325., {36., 41.}},
             SingleEvaluation->True],
            Deinitialization:>None,
            DynamicModuleValues:>{},
            SynchronousInitialization->True,
            UnsavedVariables:>{Typeset`initDone$$},
            UntrackedVariables:>{Typeset`size$$}], "Manipulate",
           Deployed->True,
           StripOnInput->False],
          Manipulate`InterpretManipulate[1]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}},
       GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
      "Column"]}
   },
   GridBoxAlignment->{"Columns" -> {{Left}}},
   GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
  "Column"]], "Output"]
}, {2}]],

Cell[BoxData[""], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Button", "[", 
  RowBox[{"\"\<Import List\>\"", ",", 
   RowBox[{"dataD0", "=", 
    RowBox[{"Import", "[", 
     RowBox[{
      RowBox[{"SystemDialogInput", "[", 
       RowBox[{"\"\<FileOpen\>\"", ",", 
        RowBox[{
        "WindowTitle", "\[Rule]", "\"\<Select a txt File to Open\>\""}]}], 
       "]"}], ",", "\"\<Table\>\""}], "]"}]}], ",", 
   RowBox[{"Method", "\[Rule]", "\"\<Queued\>\""}]}], "]"}]], "Input",
 Editable->False,
 CellOpen->False],

Cell[BoxData[
 ButtonBox["\<\"Import List\"\>",
  Appearance->Automatic,
  ButtonFunction:>($CellContext`dataD0 = Import[
     SystemDialogInput[
     "FileOpen", WindowTitle -> "Select a txt File to Open"], "Table"]),
  Evaluator->Automatic,
  Method->"Queued"]], "Output"]
}, {2}]],

Cell[BoxData["\[IndentingNewLine]"], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Panel", "[", 
  RowBox[{
   RowBox[{"Column", "[", 
    RowBox[{"{", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"Row", "[", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Manipulate", "[", 
          RowBox[{
           RowBox[{"x1", "=", "Fuc"}], ",", 
           RowBox[{"{", 
            RowBox[{"Fuc", ",", 
             RowBox[{"{", 
              RowBox[{"True", ",", "False"}], "}"}]}], "}"}], ",", 
           RowBox[{"ControlPlacement", "\[Rule]", "Left"}]}], "]"}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{"Manipulate", "[", 
          RowBox[{
           RowBox[{"x2", "=", "deNAc"}], ",", 
           RowBox[{"{", 
            RowBox[{"deNAc", ",", 
             RowBox[{"{", 
              RowBox[{"True", ",", "False"}], "}"}]}], "}"}], ",", 
           RowBox[{"ControlPlacement", "\[Rule]", "Left"}]}], "]"}]}], "}"}], 
       "]"}], ",", "\[IndentingNewLine]", 
      RowBox[{"Row", "[", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Manipulate", "[", 
          RowBox[{
           RowBox[{"x3", "=", "sulfo"}], ",", 
           RowBox[{"{", 
            RowBox[{"sulfo", ",", 
             RowBox[{"{", 
              RowBox[{"True", ",", "False"}], "}"}]}], "}"}], ",", 
           RowBox[{"ControlPlacement", "\[Rule]", "Left"}]}], "]"}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{"Manipulate", "[", 
          RowBox[{
           RowBox[{"x4", "=", "GlcA"}], ",", 
           RowBox[{"{", 
            RowBox[{"GlcA", ",", 
             RowBox[{"{", 
              RowBox[{"True", ",", "False"}], "}"}]}], "}"}], ",", 
           RowBox[{"ControlPlacement", "\[Rule]", "Left"}]}], "]"}]}], "}"}], 
       "]"}], ",", "\[IndentingNewLine]", 
      RowBox[{"Row", "[", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Manipulate", "[", 
          RowBox[{
           RowBox[{"x5", "=", "OAc"}], ",", 
           RowBox[{"{", 
            RowBox[{"OAc", ",", 
             RowBox[{"{", 
              RowBox[{"True", ",", "False"}], "}"}]}], "}"}], ",", 
           RowBox[{"ControlPlacement", "\[Rule]", "Left"}]}], "]"}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{"Manipulate", "[", 
          RowBox[{
           RowBox[{"x7", "=", "lactone"}], ",", 
           RowBox[{"{", 
            RowBox[{"lactone", ",", 
             RowBox[{"{", 
              RowBox[{"True", ",", "False"}], "}"}]}], "}"}], ",", 
           RowBox[{"ControlPlacement", "\[Rule]", "Left"}]}], "]"}]}], "}"}], 
       "]"}], ",", "\[IndentingNewLine]", 
      RowBox[{"Manipulate", "[", 
       RowBox[{
        RowBox[{"x6", "=", "HexHexNAc"}], ",", 
        RowBox[{"{", 
         RowBox[{"HexHexNAc", ",", 
          RowBox[{"{", 
           RowBox[{"True", ",", "False"}], "}"}]}], "}"}], ",", 
        RowBox[{"ControlPlacement", "\[Rule]", "Left"}]}], "]"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"Row", "[", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Manipulate", "[", 
          RowBox[{
           RowBox[{"x8", "=", "NeuGc"}], ",", 
           RowBox[{"{", 
            RowBox[{"NeuGc", ",", 
             RowBox[{"{", 
              RowBox[{"True", ",", "False"}], "}"}]}], "}"}], ",", 
           RowBox[{"ControlPlacement", "\[Rule]", "Left"}]}], "]"}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{"Manipulate", "[", 
          RowBox[{
           RowBox[{"x9", "=", "KDN"}], ",", 
           RowBox[{"{", 
            RowBox[{"KDN", ",", 
             RowBox[{"{", 
              RowBox[{"True", ",", "False"}], "}"}]}], "}"}], ",", 
           RowBox[{"ControlPlacement", "\[Rule]", "Left"}]}], "]"}]}], "}"}], 
       "]"}], ",", "\[IndentingNewLine]", 
      RowBox[{"Manipulate", "[", 
       RowBox[{
        RowBox[{"x10", "=", "Globo"}], ",", 
        RowBox[{"{", 
         RowBox[{"Globo", ",", 
          RowBox[{"{", 
           RowBox[{"True", ",", "False"}], "}"}]}], "}"}], ",", 
        RowBox[{"ControlPlacement", "\[Rule]", "Left"}]}], "]"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"Manipulate", "[", 
       RowBox[{
        RowBox[{"x11", "=", "OddNC"}], " ", ",", 
        RowBox[{"{", 
         RowBox[{"OddNC", ",", 
          RowBox[{"{", 
           RowBox[{"True", ",", "False"}], "}"}]}], "}"}], ",", 
        RowBox[{"ControlPlacement", "\[Rule]", "Left"}], ",", 
        RowBox[{"FrameLabel", "\[Rule]", 
         RowBox[{
         "{", "\"\<ceramides with odd number of C atoms\>\"", "}"}]}]}], 
       "]"}], ",", "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{"Row", "[", 
       RowBox[{"{", "}"}], "]"}], ",", "\[IndentingNewLine]", 
      RowBox[{"Button", "[", 
       RowBox[{"\"\<OK\>\"", ",", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"exclude", "=", 
          RowBox[{"{", "}"}]}], ";", 
         RowBox[{"exclude1", "=", 
          RowBox[{"{", "}"}]}], ";", "\[IndentingNewLine]", 
         RowBox[{"If", "[", 
          RowBox[{"x1", ",", ",", 
           RowBox[{"exclude", "=", 
            RowBox[{"Append", "[", 
             RowBox[{"exclude", ",", "\"\<Fuc\>\""}], "]"}]}]}], "]"}], ";", 
         "\[IndentingNewLine]", 
         RowBox[{"If", "[", 
          RowBox[{"x2", ",", ",", 
           RowBox[{"exclude", "=", 
            RowBox[{"Append", "[", 
             RowBox[{"exclude", ",", "\"\<de-N-Ac\>\""}], "]"}]}]}], "]"}], 
         ";", "\[IndentingNewLine]", 
         RowBox[{"If", "[", 
          RowBox[{"x3", ",", ",", 
           RowBox[{"exclude", "=", 
            RowBox[{"Append", "[", 
             RowBox[{"exclude", ",", " ", "\"\<sulfo\>\""}], "]"}]}]}], "]"}],
          ";", "\[IndentingNewLine]", 
         RowBox[{"If", "[", 
          RowBox[{"x4", ",", ",", 
           RowBox[{"exclude", "=", 
            RowBox[{"Append", "[", 
             RowBox[{"exclude", ",", "\"\<GlcA\>\""}], "]"}]}]}], "]"}], ";", 
         "\[IndentingNewLine]", 
         RowBox[{"If", "[", 
          RowBox[{"x5", ",", ",", 
           RowBox[{"exclude", "=", 
            RowBox[{"Append", "[", 
             RowBox[{"exclude", ",", "\"\<OAc\>\""}], "]"}]}]}], "]"}], ";", 
         "\[IndentingNewLine]", 
         RowBox[{"If", "[", 
          RowBox[{"x6", ",", ",", 
           RowBox[{"exclude", "=", 
            RowBox[{"Append", "[", 
             RowBox[{"exclude", ",", "\"\<(Hex-HexNAc)\>\""}], "]"}]}]}], 
          "]"}], ";", "\[IndentingNewLine]", 
         RowBox[{"If", "[", 
          RowBox[{"x7", ",", ",", 
           RowBox[{"exclude", "=", 
            RowBox[{"Append", "[", 
             RowBox[{"exclude", ",", "\"\<lactone\>\""}], "]"}]}]}], "]"}], 
         ";", "\[IndentingNewLine]", 
         RowBox[{"If", "[", 
          RowBox[{"x8", ",", ",", 
           RowBox[{"exclude", "=", 
            RowBox[{"Append", "[", 
             RowBox[{"exclude", ",", "\"\<NeuGc\>\""}], "]"}]}]}], "]"}], ";",
          "\[IndentingNewLine]", 
         RowBox[{"If", "[", 
          RowBox[{"x9", ",", ",", 
           RowBox[{"exclude", "=", 
            RowBox[{"Append", "[", 
             RowBox[{"exclude", ",", "\"\<KDN\>\""}], "]"}]}]}], "]"}], ";", 
         "\[IndentingNewLine]", 
         RowBox[{"If", "[", 
          RowBox[{"x10", ",", ",", 
           RowBox[{"exclude", "=", 
            RowBox[{"Append", "[", 
             RowBox[{"exclude", ",", "\"\<Gb\>\""}], "]"}]}]}], "]"}], ";", 
         "\[IndentingNewLine]", 
         RowBox[{"If", "[", 
          RowBox[{"x11", ",", ",", 
           RowBox[{"exclude1", "=", 
            RowBox[{"Flatten", "[", 
             RowBox[{"Append", "[", 
              RowBox[{"exclude1", ",", 
               RowBox[{"{", 
                RowBox[{
                "\"\</15:\>\"", ",", "\"\</17:\>\"", ",", "\"\</19:\>\"", 
                 ",", "\"\</21:\>\"", ",", "\"\</23:\>\""}], "}"}]}], "]"}], 
             "]"}]}]}], "]"}], ";"}], "\[IndentingNewLine]", ",", 
        RowBox[{"Method", "\[Rule]", "\"\<Queued\>\""}]}], "]"}]}], 
     "\[IndentingNewLine]", "\[IndentingNewLine]", "\[IndentingNewLine]", 
     "}"}], "]"}], ",", "\"\<Include in Search\>\""}], "]"}]], "Input",
 Editable->False,
 CellOpen->False],

Cell[BoxData[
 TemplateBox[{PanelBox[
    TagBox[
     GridBox[{{
        TemplateBox[{
          TagBox[
           StyleBox[
            
            DynamicModuleBox[{$CellContext`Fuc$$ = True, Typeset`show$$ = 
              True, Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = 
              "Menu", Typeset`animator$$, Typeset`animvar$$ = 1, 
              Typeset`name$$ = "\"untitled\"", Typeset`specs$$ = {{
                 Hold[$CellContext`Fuc$$], {True, False}}}, 
              Typeset`size$$ = {24., {0., 9.}}, Typeset`update$$ = 0, 
              Typeset`initDone$$, Typeset`skipInitDone$$ = 
              True, $CellContext`Fuc$4804$$ = False}, 
             DynamicBox[
              Manipulate`ManipulateBoxes[
              1, StandardForm, "Variables" :> {$CellContext`Fuc$$ = True}, 
               "ControllerVariables" :> {
                 Hold[$CellContext`Fuc$$, $CellContext`Fuc$4804$$, False]}, 
               "OtherVariables" :> {
                Typeset`show$$, Typeset`bookmarkList$$, 
                 Typeset`bookmarkMode$$, Typeset`animator$$, 
                 Typeset`animvar$$, Typeset`name$$, Typeset`specs$$, 
                 Typeset`size$$, Typeset`update$$, Typeset`initDone$$, 
                 Typeset`skipInitDone$$}, 
               "Body" :> ($CellContext`x1 = $CellContext`Fuc$$), 
               "Specifications" :> {{$CellContext`Fuc$$, {True, False}}}, 
               "Options" :> {ControlPlacement -> Left}, 
               "DefaultOptions" :> {}], ImageSizeCache -> {115., {35., 42.}}, 
              SingleEvaluation -> True], Deinitialization :> None, 
             DynamicModuleValues :> {}, SynchronousInitialization -> True, 
             UnsavedVariables :> {Typeset`initDone$$}, 
             UntrackedVariables :> {Typeset`size$$}], "Manipulate", Deployed -> 
            True, StripOnInput -> False], 
           Manipulate`InterpretManipulate[1]], 
          TagBox[
           StyleBox[
            
            DynamicModuleBox[{$CellContext`deNAc$$ = True, Typeset`show$$ = 
              True, Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = 
              "Menu", Typeset`animator$$, Typeset`animvar$$ = 1, 
              Typeset`name$$ = "\"untitled\"", Typeset`specs$$ = {{
                 Hold[$CellContext`deNAc$$], {True, False}}}, Typeset`size$$ = 
              {24., {0., 9.}}, Typeset`update$$ = 0, Typeset`initDone$$, 
              Typeset`skipInitDone$$ = True, $CellContext`deNAc$4821$$ = 
              False}, 
             DynamicBox[
              Manipulate`ManipulateBoxes[
              1, StandardForm, "Variables" :> {$CellContext`deNAc$$ = True}, 
               "ControllerVariables" :> {
                 
                 Hold[$CellContext`deNAc$$, $CellContext`deNAc$4821$$, 
                  False]}, 
               "OtherVariables" :> {
                Typeset`show$$, Typeset`bookmarkList$$, 
                 Typeset`bookmarkMode$$, Typeset`animator$$, 
                 Typeset`animvar$$, Typeset`name$$, Typeset`specs$$, 
                 Typeset`size$$, Typeset`update$$, Typeset`initDone$$, 
                 Typeset`skipInitDone$$}, 
               "Body" :> ($CellContext`x2 = $CellContext`deNAc$$), 
               "Specifications" :> {{$CellContext`deNAc$$, {True, False}}}, 
               "Options" :> {ControlPlacement -> Left}, 
               "DefaultOptions" :> {}], ImageSizeCache -> {130., {35., 42.}}, 
              SingleEvaluation -> True], Deinitialization :> None, 
             DynamicModuleValues :> {}, SynchronousInitialization -> True, 
             UnsavedVariables :> {Typeset`initDone$$}, 
             UntrackedVariables :> {Typeset`size$$}], "Manipulate", Deployed -> 
            True, StripOnInput -> False], 
           Manipulate`InterpretManipulate[1]]}, "Row", 
         DisplayFunction -> (RowBox[{#, "\[InvisibleSpace]", #2}]& ), 
         InterpretationFunction -> (RowBox[{"Row", "[", 
            RowBox[{"{", 
              RowBox[{#, ",", #2}], "}"}], "]"}]& )]}, {
        TemplateBox[{
          TagBox[
           StyleBox[
            
            DynamicModuleBox[{$CellContext`sulfo$$ = True, Typeset`show$$ = 
              True, Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = 
              "Menu", Typeset`animator$$, Typeset`animvar$$ = 1, 
              Typeset`name$$ = "\"untitled\"", Typeset`specs$$ = {{
                 Hold[$CellContext`sulfo$$], {True, False}}}, 
              Typeset`size$$ = {24., {0., 9.}}, Typeset`update$$ = 0, 
              Typeset`initDone$$, Typeset`skipInitDone$$ = 
              True, $CellContext`sulfo$4839$$ = False}, 
             DynamicBox[
              Manipulate`ManipulateBoxes[
              1, StandardForm, "Variables" :> {$CellContext`sulfo$$ = True}, 
               "ControllerVariables" :> {
                 
                 Hold[$CellContext`sulfo$$, $CellContext`sulfo$4839$$, 
                  False]}, 
               "OtherVariables" :> {
                Typeset`show$$, Typeset`bookmarkList$$, 
                 Typeset`bookmarkMode$$, Typeset`animator$$, 
                 Typeset`animvar$$, Typeset`name$$, Typeset`specs$$, 
                 Typeset`size$$, Typeset`update$$, Typeset`initDone$$, 
                 Typeset`skipInitDone$$}, 
               "Body" :> ($CellContext`x3 = $CellContext`sulfo$$), 
               "Specifications" :> {{$CellContext`sulfo$$, {True, False}}}, 
               "Options" :> {ControlPlacement -> Left}, 
               "DefaultOptions" :> {}], ImageSizeCache -> {123., {35., 42.}}, 
              SingleEvaluation -> True], Deinitialization :> None, 
             DynamicModuleValues :> {}, SynchronousInitialization -> True, 
             UnsavedVariables :> {Typeset`initDone$$}, 
             UntrackedVariables :> {Typeset`size$$}], "Manipulate", Deployed -> 
            True, StripOnInput -> False], 
           Manipulate`InterpretManipulate[1]], 
          TagBox[
           StyleBox[
            
            DynamicModuleBox[{$CellContext`GlcA$$ = True, Typeset`show$$ = 
              True, Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = 
              "Menu", Typeset`animator$$, Typeset`animvar$$ = 1, 
              Typeset`name$$ = "\"untitled\"", Typeset`specs$$ = {{
                 Hold[$CellContext`GlcA$$], {True, False}}}, 
              Typeset`size$$ = {24., {0., 9.}}, Typeset`update$$ = 0, 
              Typeset`initDone$$, Typeset`skipInitDone$$ = 
              True, $CellContext`GlcA$4856$$ = False}, 
             DynamicBox[
              Manipulate`ManipulateBoxes[
              1, StandardForm, "Variables" :> {$CellContext`GlcA$$ = True}, 
               "ControllerVariables" :> {
                 Hold[$CellContext`GlcA$$, $CellContext`GlcA$4856$$, False]}, 
               "OtherVariables" :> {
                Typeset`show$$, Typeset`bookmarkList$$, 
                 Typeset`bookmarkMode$$, Typeset`animator$$, 
                 Typeset`animvar$$, Typeset`name$$, Typeset`specs$$, 
                 Typeset`size$$, Typeset`update$$, Typeset`initDone$$, 
                 Typeset`skipInitDone$$}, 
               "Body" :> ($CellContext`x4 = $CellContext`GlcA$$), 
               "Specifications" :> {{$CellContext`GlcA$$, {True, False}}}, 
               "Options" :> {ControlPlacement -> Left}, 
               "DefaultOptions" :> {}], ImageSizeCache -> {120., {35., 42.}}, 
              SingleEvaluation -> True], Deinitialization :> None, 
             DynamicModuleValues :> {}, SynchronousInitialization -> True, 
             UnsavedVariables :> {Typeset`initDone$$}, 
             UntrackedVariables :> {Typeset`size$$}], "Manipulate", Deployed -> 
            True, StripOnInput -> False], 
           Manipulate`InterpretManipulate[1]]}, "Row", 
         DisplayFunction -> (RowBox[{#, "\[InvisibleSpace]", #2}]& ), 
         InterpretationFunction -> (RowBox[{"Row", "[", 
            RowBox[{"{", 
              RowBox[{#, ",", #2}], "}"}], "]"}]& )]}, {
        TemplateBox[{
          TagBox[
           StyleBox[
            
            DynamicModuleBox[{$CellContext`OAc$$ = True, Typeset`show$$ = 
              True, Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = 
              "Menu", Typeset`animator$$, Typeset`animvar$$ = 1, 
              Typeset`name$$ = "\"untitled\"", Typeset`specs$$ = {{
                 Hold[$CellContext`OAc$$], {True, False}}}, 
              Typeset`size$$ = {24., {0., 9.}}, Typeset`update$$ = 0, 
              Typeset`initDone$$, Typeset`skipInitDone$$ = 
              True, $CellContext`OAc$4874$$ = False}, 
             DynamicBox[
              Manipulate`ManipulateBoxes[
              1, StandardForm, "Variables" :> {$CellContext`OAc$$ = True}, 
               "ControllerVariables" :> {
                 Hold[$CellContext`OAc$$, $CellContext`OAc$4874$$, False]}, 
               "OtherVariables" :> {
                Typeset`show$$, Typeset`bookmarkList$$, 
                 Typeset`bookmarkMode$$, Typeset`animator$$, 
                 Typeset`animvar$$, Typeset`name$$, Typeset`specs$$, 
                 Typeset`size$$, Typeset`update$$, Typeset`initDone$$, 
                 Typeset`skipInitDone$$}, 
               "Body" :> ($CellContext`x5 = $CellContext`OAc$$), 
               "Specifications" :> {{$CellContext`OAc$$, {True, False}}}, 
               "Options" :> {ControlPlacement -> Left}, 
               "DefaultOptions" :> {}], ImageSizeCache -> {118., {35., 42.}}, 
              SingleEvaluation -> True], Deinitialization :> None, 
             DynamicModuleValues :> {}, SynchronousInitialization -> True, 
             UnsavedVariables :> {Typeset`initDone$$}, 
             UntrackedVariables :> {Typeset`size$$}], "Manipulate", Deployed -> 
            True, StripOnInput -> False], 
           Manipulate`InterpretManipulate[1]], 
          TagBox[
           StyleBox[
            
            DynamicModuleBox[{$CellContext`lactone$$ = True, Typeset`show$$ = 
              True, Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = 
              "Menu", Typeset`animator$$, Typeset`animvar$$ = 1, 
              Typeset`name$$ = "\"untitled\"", Typeset`specs$$ = {{
                 Hold[$CellContext`lactone$$], {True, False}}}, 
              Typeset`size$$ = {24., {0., 9.}}, Typeset`update$$ = 0, 
              Typeset`initDone$$, Typeset`skipInitDone$$ = 
              True, $CellContext`lactone$4891$$ = False}, 
             DynamicBox[
              Manipulate`ManipulateBoxes[
              1, StandardForm, "Variables" :> {$CellContext`lactone$$ = True},
                "ControllerVariables" :> {
                 
                 Hold[$CellContext`lactone$$, $CellContext`lactone$4891$$, 
                  False]}, 
               "OtherVariables" :> {
                Typeset`show$$, Typeset`bookmarkList$$, 
                 Typeset`bookmarkMode$$, Typeset`animator$$, 
                 Typeset`animvar$$, Typeset`name$$, Typeset`specs$$, 
                 Typeset`size$$, Typeset`update$$, Typeset`initDone$$, 
                 Typeset`skipInitDone$$}, 
               "Body" :> ($CellContext`x7 = $CellContext`lactone$$), 
               "Specifications" :> {{$CellContext`lactone$$, {True, False}}}, 
               "Options" :> {ControlPlacement -> Left}, 
               "DefaultOptions" :> {}], ImageSizeCache -> {135., {35., 42.}}, 
              SingleEvaluation -> True], Deinitialization :> None, 
             DynamicModuleValues :> {}, SynchronousInitialization -> True, 
             UnsavedVariables :> {Typeset`initDone$$}, 
             UntrackedVariables :> {Typeset`size$$}], "Manipulate", Deployed -> 
            True, StripOnInput -> False], 
           Manipulate`InterpretManipulate[1]]}, "Row", 
         DisplayFunction -> (RowBox[{#, "\[InvisibleSpace]", #2}]& ), 
         InterpretationFunction -> (RowBox[{"Row", "[", 
            RowBox[{"{", 
              RowBox[{#, ",", #2}], "}"}], "]"}]& )]}, {
        TagBox[
         StyleBox[
          
          DynamicModuleBox[{$CellContext`HexHexNAc$$ = True, Typeset`show$$ = 
            True, Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = 
            "Menu", Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
            "\"untitled\"", Typeset`specs$$ = {{
               Hold[$CellContext`HexHexNAc$$], {True, False}}}, 
            Typeset`size$$ = {24., {0., 9.}}, Typeset`update$$ = 0, 
            Typeset`initDone$$, Typeset`skipInitDone$$ = 
            True, $CellContext`HexHexNAc$4908$$ = False}, 
           DynamicBox[
            Manipulate`ManipulateBoxes[
            1, StandardForm, "Variables" :> {$CellContext`HexHexNAc$$ = True},
              "ControllerVariables" :> {
               
               Hold[$CellContext`HexHexNAc$$, $CellContext`HexHexNAc$4908$$, 
                False]}, 
             "OtherVariables" :> {
              Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
               Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
               Typeset`specs$$, Typeset`size$$, Typeset`update$$, 
               Typeset`initDone$$, Typeset`skipInitDone$$}, 
             "Body" :> ($CellContext`x6 = $CellContext`HexHexNAc$$), 
             "Specifications" :> {{$CellContext`HexHexNAc$$, {True, False}}}, 
             "Options" :> {ControlPlacement -> Left}, "DefaultOptions" :> {}],
             ImageSizeCache -> {155., {35., 42.}}, SingleEvaluation -> True], 
           Deinitialization :> None, DynamicModuleValues :> {}, 
           SynchronousInitialization -> True, 
           UnsavedVariables :> {Typeset`initDone$$}, 
           UntrackedVariables :> {Typeset`size$$}], "Manipulate", Deployed -> 
          True, StripOnInput -> False], 
         Manipulate`InterpretManipulate[1]]}, {
        TemplateBox[{
          TagBox[
           StyleBox[
            
            DynamicModuleBox[{$CellContext`NeuGc$$ = True, Typeset`show$$ = 
              True, Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = 
              "Menu", Typeset`animator$$, Typeset`animvar$$ = 1, 
              Typeset`name$$ = "\"untitled\"", Typeset`specs$$ = {{
                 Hold[$CellContext`NeuGc$$], {True, False}}}, 
              Typeset`size$$ = {24., {0., 9.}}, Typeset`update$$ = 0, 
              Typeset`initDone$$, Typeset`skipInitDone$$ = 
              True, $CellContext`NeuGc$4926$$ = False}, 
             DynamicBox[
              Manipulate`ManipulateBoxes[
              1, StandardForm, "Variables" :> {$CellContext`NeuGc$$ = True}, 
               "ControllerVariables" :> {
                 
                 Hold[$CellContext`NeuGc$$, $CellContext`NeuGc$4926$$, 
                  False]}, 
               "OtherVariables" :> {
                Typeset`show$$, Typeset`bookmarkList$$, 
                 Typeset`bookmarkMode$$, Typeset`animator$$, 
                 Typeset`animvar$$, Typeset`name$$, Typeset`specs$$, 
                 Typeset`size$$, Typeset`update$$, Typeset`initDone$$, 
                 Typeset`skipInitDone$$}, 
               "Body" :> ($CellContext`x8 = $CellContext`NeuGc$$), 
               "Specifications" :> {{$CellContext`NeuGc$$, {True, False}}}, 
               "Options" :> {ControlPlacement -> Left}, 
               "DefaultOptions" :> {}], ImageSizeCache -> {131., {35., 42.}}, 
              SingleEvaluation -> True], Deinitialization :> None, 
             DynamicModuleValues :> {}, SynchronousInitialization -> True, 
             UnsavedVariables :> {Typeset`initDone$$}, 
             UntrackedVariables :> {Typeset`size$$}], "Manipulate", Deployed -> 
            True, StripOnInput -> False], 
           Manipulate`InterpretManipulate[1]], 
          TagBox[
           StyleBox[
            
            DynamicModuleBox[{$CellContext`KDN$$ = True, Typeset`show$$ = 
              True, Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = 
              "Menu", Typeset`animator$$, Typeset`animvar$$ = 1, 
              Typeset`name$$ = "\"untitled\"", Typeset`specs$$ = {{
                 Hold[$CellContext`KDN$$], {True, False}}}, 
              Typeset`size$$ = {24., {0., 9.}}, Typeset`update$$ = 0, 
              Typeset`initDone$$, Typeset`skipInitDone$$ = 
              True, $CellContext`KDN$4943$$ = False}, 
             DynamicBox[
              Manipulate`ManipulateBoxes[
              1, StandardForm, "Variables" :> {$CellContext`KDN$$ = True}, 
               "ControllerVariables" :> {
                 Hold[$CellContext`KDN$$, $CellContext`KDN$4943$$, False]}, 
               "OtherVariables" :> {
                Typeset`show$$, Typeset`bookmarkList$$, 
                 Typeset`bookmarkMode$$, Typeset`animator$$, 
                 Typeset`animvar$$, Typeset`name$$, Typeset`specs$$, 
                 Typeset`size$$, Typeset`update$$, Typeset`initDone$$, 
                 Typeset`skipInitDone$$}, 
               "Body" :> ($CellContext`x9 = $CellContext`KDN$$), 
               "Specifications" :> {{$CellContext`KDN$$, {True, False}}}, 
               "Options" :> {ControlPlacement -> Left}, 
               "DefaultOptions" :> {}], ImageSizeCache -> {119., {35., 42.}}, 
              SingleEvaluation -> True], Deinitialization :> None, 
             DynamicModuleValues :> {}, SynchronousInitialization -> True, 
             UnsavedVariables :> {Typeset`initDone$$}, 
             UntrackedVariables :> {Typeset`size$$}], "Manipulate", Deployed -> 
            True, StripOnInput -> False], 
           Manipulate`InterpretManipulate[1]]}, "Row", 
         DisplayFunction -> (RowBox[{#, "\[InvisibleSpace]", #2}]& ), 
         InterpretationFunction -> (RowBox[{"Row", "[", 
            RowBox[{"{", 
              RowBox[{#, ",", #2}], "}"}], "]"}]& )]}, {
        TagBox[
         StyleBox[
          
          DynamicModuleBox[{$CellContext`Globo$$ = True, Typeset`show$$ = 
            True, Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = 
            "Menu", Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
            "\"untitled\"", Typeset`specs$$ = {{
               Hold[$CellContext`Globo$$], {True, False}}}, 
            Typeset`size$$ = {24., {0., 9.}}, Typeset`update$$ = 0, 
            Typeset`initDone$$, Typeset`skipInitDone$$ = 
            True, $CellContext`Globo$4960$$ = False}, 
           DynamicBox[
            Manipulate`ManipulateBoxes[
            1, StandardForm, "Variables" :> {$CellContext`Globo$$ = True}, 
             "ControllerVariables" :> {
               Hold[$CellContext`Globo$$, $CellContext`Globo$4960$$, False]}, 
             "OtherVariables" :> {
              Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
               Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
               Typeset`specs$$, Typeset`size$$, Typeset`update$$, 
               Typeset`initDone$$, Typeset`skipInitDone$$}, 
             "Body" :> ($CellContext`x10 = $CellContext`Globo$$), 
             "Specifications" :> {{$CellContext`Globo$$, {True, False}}}, 
             "Options" :> {ControlPlacement -> Left}, "DefaultOptions" :> {}],
             ImageSizeCache -> {129., {35., 42.}}, SingleEvaluation -> True], 
           Deinitialization :> None, DynamicModuleValues :> {}, 
           SynchronousInitialization -> True, 
           UnsavedVariables :> {Typeset`initDone$$}, 
           UntrackedVariables :> {Typeset`size$$}], "Manipulate", Deployed -> 
          True, StripOnInput -> False], 
         Manipulate`InterpretManipulate[1]]}, {
        TagBox[
         StyleBox[
          
          DynamicModuleBox[{$CellContext`OddNC$$ = True, Typeset`show$$ = 
            True, Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = 
            "Menu", Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
            "\"untitled\"", Typeset`specs$$ = {{
               Hold[$CellContext`OddNC$$], {True, False}}}, 
            Typeset`size$$ = {24., {0., 9.}}, Typeset`update$$ = 0, 
            Typeset`initDone$$, Typeset`skipInitDone$$ = 
            True, $CellContext`OddNC$4977$$ = False}, 
           DynamicBox[
            Manipulate`ManipulateBoxes[
            1, StandardForm, "Variables" :> {$CellContext`OddNC$$ = True}, 
             "ControllerVariables" :> {
               Hold[$CellContext`OddNC$$, $CellContext`OddNC$4977$$, False]}, 
             "OtherVariables" :> {
              Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
               Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
               Typeset`specs$$, Typeset`size$$, Typeset`update$$, 
               Typeset`initDone$$, Typeset`skipInitDone$$}, 
             "Body" :> ($CellContext`x11 = $CellContext`OddNC$$), 
             "Specifications" :> {{$CellContext`OddNC$$, {True, False}}}, 
             "Options" :> {
              ControlPlacement -> Left, 
               FrameLabel -> {"ceramides with odd number of C atoms"}}, 
             "DefaultOptions" :> {}], ImageSizeCache -> {220., {44., 51.}}, 
            SingleEvaluation -> True], Deinitialization :> None, 
           DynamicModuleValues :> {}, SynchronousInitialization -> True, 
           UnsavedVariables :> {Typeset`initDone$$}, 
           UntrackedVariables :> {Typeset`size$$}], "Manipulate", Deployed -> 
          True, StripOnInput -> False], 
         Manipulate`InterpretManipulate[1]]}, {
        TemplateBox[{}, "Row", DisplayFunction -> (""& ), 
         InterpretationFunction -> (RowBox[{"Row", "[", 
            RowBox[{"{", "}"}], "]"}]& )]}, {
        ButtonBox[
        "\"OK\"", Appearance -> Automatic, 
         ButtonFunction :> ($CellContext`exclude = {}; $CellContext`exclude1 = \
{}; If[$CellContext`x1, Null, $CellContext`exclude = 
            Append[$CellContext`exclude, "Fuc"]]; 
          If[$CellContext`x2, Null, $CellContext`exclude = 
            Append[$CellContext`exclude, "de-N-Ac"]]; 
          If[$CellContext`x3, Null, $CellContext`exclude = 
            Append[$CellContext`exclude, "sulfo"]]; 
          If[$CellContext`x4, Null, $CellContext`exclude = 
            Append[$CellContext`exclude, "GlcA"]]; 
          If[$CellContext`x5, Null, $CellContext`exclude = 
            Append[$CellContext`exclude, "OAc"]]; 
          If[$CellContext`x6, Null, $CellContext`exclude = 
            Append[$CellContext`exclude, "(Hex-HexNAc)"]]; 
          If[$CellContext`x7, Null, $CellContext`exclude = 
            Append[$CellContext`exclude, "lactone"]]; 
          If[$CellContext`x8, Null, $CellContext`exclude = 
            Append[$CellContext`exclude, "NeuGc"]]; 
          If[$CellContext`x9, Null, $CellContext`exclude = 
            Append[$CellContext`exclude, "KDN"]]; 
          If[$CellContext`x10, Null, $CellContext`exclude = 
            Append[$CellContext`exclude, "Gb"]]; 
          If[$CellContext`x11, Null, $CellContext`exclude1 = Flatten[
              
              Append[$CellContext`exclude1, {
               "/15:", "/17:", "/19:", "/21:", "/23:"}]]]; Null), Evaluator -> 
         Automatic, Method -> "Queued"]}}, 
      GridBoxAlignment -> {"Columns" -> {{Left}}}, 
      GridBoxItemSize -> {
       "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}], "Column"]],
   "\"Include in Search\""},
  "Labeled",
  DisplayFunction->(GridBox[{{
      ItemBox[#2, Alignment -> {Left, Inherited}, DefaultBaseStyle -> 
       "PanelLabel"]}, {
      TagBox[
       ItemBox[
        PaneBox[
         TagBox[#, "SkipImageSizeLevel"], Alignment -> {Center, Baseline}, 
         BaselinePosition -> Baseline], DefaultBaseStyle -> "Labeled"], 
       "SkipImageSizeLevel"]}}, 
    GridBoxAlignment -> {"Columns" -> {{Center}}, "Rows" -> {{Center}}}, 
    AutoDelete -> False, 
    GridBoxItemSize -> {"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
    BaselinePosition -> {2, 1}]& ),
  InterpretationFunction->(RowBox[{"Labeled", "[", 
     RowBox[{#, ",", 
       RowBox[{"{", #2, "}"}], ",", 
       RowBox[{"{", 
         RowBox[{"{", 
           RowBox[{"Top", ",", "Left"}], "}"}], "}"}], ",", 
       RowBox[{"DefaultLabelStyle", "\[Rule]", "\"PanelLabel\""}], ",", 
       RowBox[{"LabelStyle", "\[Rule]", 
         RowBox[{"{", "}"}]}], ",", 
       RowBox[{"RotateLabel", "\[Rule]", "False"}], ",", 
       RowBox[{"Spacings", "\[Rule]", "Automatic"}]}], "]"}]& )]], "Output"]
}, {2}]],

Cell[BoxData[""], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Button", "[", 
   RowBox[{"\"\<Search\>\"", ",", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"Clear", "[", "dataD1", "]"}], ";", " ", 
     RowBox[{"dataD1", "=", 
      RowBox[{"{", "}"}]}], ";", 
     RowBox[{"baza", "=", 
      RowBox[{"Select", "[", 
       RowBox[{"baza0", ",", 
        RowBox[{
         RowBox[{
          RowBox[{"StringFreeQ", "[", 
           RowBox[{
            RowBox[{"#", "[", 
             RowBox[{"[", "2", "]"}], "]"}], ",", "exclude"}], "]"}], "&&", 
          RowBox[{"StringFreeQ", "[", 
           RowBox[{
            RowBox[{"#", "[", 
             RowBox[{"[", "3", "]"}], "]"}], ",", "exclude1"}], "]"}]}], 
         "&"}]}], "]"}]}], ";", 
     RowBox[{"progress", "=", "0"}], ";", 
     RowBox[{"duzina", "=", 
      RowBox[{"Length", "[", "dataD0", "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"Do", "[", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{
        RowBox[{"Do", "[", 
         RowBox[{
          RowBox[{"If", "[", 
           RowBox[{
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"dataD0", "[", 
                RowBox[{"[", 
                 RowBox[{"i", ",", "1"}], "]"}], "]"}], "-", "Tole"}], ")"}], 
             "\[LessEqual]", 
             RowBox[{"baza", "[", 
              RowBox[{"[", 
               RowBox[{"j", ",", "1"}], "]"}], "]"}], "\[LessEqual]", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"dataD0", "[", 
                RowBox[{"[", 
                 RowBox[{"i", ",", "1"}], "]"}], "]"}], "+", "Tole"}], 
              ")"}]}], ",", 
            RowBox[{
             RowBox[{"Clear", "[", 
              RowBox[{
              "a", ",", "b", ",", "c", ",", "d", ",", "e", ",", "baza1"}], 
              "]"}], ";", 
             RowBox[{"a", "=", 
              RowBox[{"{", "}"}]}], ";", 
             RowBox[{"b", "=", 
              RowBox[{"{", "}"}]}], ";", 
             RowBox[{"c", "=", 
              RowBox[{"{", "}"}]}], ";", 
             RowBox[{"d", "=", 
              RowBox[{"{", "}"}]}], ";", 
             RowBox[{"e", "=", 
              RowBox[{"{", "}"}]}], ";", "\[IndentingNewLine]", 
             RowBox[{"baza1", "=", 
              RowBox[{"Select", "[", 
               RowBox[{"baza0", ",", 
                RowBox[{
                 RowBox[{
                  RowBox[{"#", "[", 
                   RowBox[{"[", 
                    RowBox[{"-", "1"}], "]"}], "]"}], "\[Equal]", 
                  RowBox[{"baza", "[", 
                   RowBox[{"[", 
                    RowBox[{"j", ",", 
                    RowBox[{"-", "1"}]}], "]"}], "]"}]}], "&"}]}], "]"}]}], 
             ";", "\[IndentingNewLine]", 
             RowBox[{"Do", "[", "\[IndentingNewLine]", "\[IndentingNewLine]", 
              RowBox[{
               RowBox[{
                RowBox[{"Do", "[", " ", 
                 RowBox[{
                  RowBox[{"If", "[", 
                   RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{"dataD0", "[", 
                    RowBox[{"[", 
                    RowBox[{"i", ",", "z"}], "]"}], "]"}], "-", "ToleMSMS"}], 
                    "\[LessEqual]", 
                    RowBox[{"baza1", "[", 
                    RowBox[{"[", 
                    RowBox[{"w", ",", "1"}], "]"}], "]"}], "\[LessEqual]", 
                    RowBox[{
                    RowBox[{"dataD0", "[", 
                    RowBox[{"[", 
                    RowBox[{"i", ",", "z"}], "]"}], "]"}], "+", 
                    "ToleMSMS"}]}], "||", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"dataD0", "[", 
                    RowBox[{"[", 
                    RowBox[{"i", ",", "z"}], "]"}], "]"}], "-", "ToleMSMS"}], 
                    "\[LessEqual]", 
                    RowBox[{
                    RowBox[{"baza1", "[", 
                    RowBox[{"[", 
                    RowBox[{"w", ",", "1"}], "]"}], "]"}], "-", "18.0152"}], 
                    "\[LessEqual]", 
                    RowBox[{
                    RowBox[{"dataD0", "[", 
                    RowBox[{"[", 
                    RowBox[{"i", ",", "z"}], "]"}], "]"}], "+", 
                    "ToleMSMS"}]}]}], ")"}], " ", ",", " ", 
                    "\[IndentingNewLine]", "\[IndentingNewLine]", 
                    RowBox[{
                    StyleBox[
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"!", 
                    RowBox[{"StringFreeQ", "[", 
                    RowBox[{
                    RowBox[{"baza1", "[", 
                    RowBox[{"[", 
                    RowBox[{"w", ",", "2"}], "]"}], "]"}], ",", 
                    "\"\<Gb4\>\""}], "]"}]}], ",", 
                    RowBox[{"Continue", "[", "]"}]}], "]"}],
                    Background->RGBColor[1, 0.85, 0.85]], 
                    StyleBox[";",
                    Background->RGBColor[1, 0.85, 0.85]], 
                    "\[IndentingNewLine]", 
                    StyleBox[
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"!", 
                    RowBox[{"StringFreeQ", "[", 
                    RowBox[{
                    RowBox[{"baza", "[", 
                    RowBox[{"[", 
                    RowBox[{"j", ",", "2"}], "]"}], "]"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"\"\<LM\>\"", ",", "\"\<LD\>\""}], "}"}]}], 
                    "]"}]}], "&&", 
                    RowBox[{"!", 
                    RowBox[{"StringFreeQ", "[", 
                    RowBox[{
                    RowBox[{"baza1", "[", 
                    RowBox[{"[", 
                    RowBox[{"w", ",", "2"}], "]"}], "]"}], ",", 
                    RowBox[{"{", 
                    RowBox[{
                    "\"\<KDN\>\"", ",", "\"\<NeuGc\>\"", ",", "\"\<OAc\>\"", 
                    ",", "\"\<de-N-Ac\>\""}], "}"}]}], "]"}]}]}], ",", 
                    RowBox[{"Continue", "[", "]"}]}], "]"}],
                    Background->RGBColor[1, 0.85, 0.85]], 
                    StyleBox[";",
                    Background->RGBColor[1, 0.85, 0.85]], 
                    "\[IndentingNewLine]", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"StringFreeQ", "[", 
                    RowBox[{
                    RowBox[{"baza", "[", 
                    RowBox[{"[", 
                    RowBox[{"j", ",", "2"}], "]"}], "]"}], ",", 
                    "\"\<lactone\>\""}], "]"}], "&&", 
                    RowBox[{"!", 
                    RowBox[{"StringFreeQ", "[", 
                    RowBox[{
                    RowBox[{"baza1", "[", 
                    RowBox[{"[", 
                    RowBox[{"w", ",", "2"}], "]"}], "]"}], ",", 
                    "\"\<lactone\>\""}], "]"}]}]}], ",", 
                    RowBox[{"Continue", "[", "]"}]}], "]"}], ";", 
                    "\[IndentingNewLine]", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"!", 
                    RowBox[{"StringFreeQ", "[", 
                    RowBox[{
                    RowBox[{"baza1", "[", 
                    RowBox[{"[", 
                    RowBox[{"w", ",", "2"}], "]"}], "]"}], ",", 
                    "\"\<GM4\>\""}], "]"}]}], ",", 
                    RowBox[{"Continue", "[", "]"}]}], "]"}], ";", 
                    "\[IndentingNewLine]", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"StringFreeQ", "[", 
                    RowBox[{
                    RowBox[{"baza", "[", 
                    RowBox[{"[", 
                    RowBox[{"j", ",", "2"}], "]"}], "]"}], ",", 
                    "\"\<KDN\>\""}], "]"}], "&&", 
                    RowBox[{"!", 
                    RowBox[{"StringFreeQ", "[", 
                    RowBox[{
                    RowBox[{"baza1", "[", 
                    RowBox[{"[", 
                    RowBox[{"w", ",", "2"}], "]"}], "]"}], ",", 
                    "\"\<KDN\>\""}], "]"}]}]}], ",", 
                    RowBox[{"Continue", "[", "]"}]}], "]"}], ";", 
                    "\[IndentingNewLine]", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"StringFreeQ", "[", 
                    RowBox[{
                    RowBox[{"baza", "[", 
                    RowBox[{"[", 
                    RowBox[{"j", ",", "2"}], "]"}], "]"}], ",", 
                    "\"\<NeuGc\>\""}], "]"}], "&&", 
                    RowBox[{"!", 
                    RowBox[{"StringFreeQ", "[", 
                    RowBox[{
                    RowBox[{"baza1", "[", 
                    RowBox[{"[", 
                    RowBox[{"w", ",", "2"}], "]"}], "]"}], ",", 
                    "\"\<NeuGc\>\""}], "]"}]}]}], ",", 
                    RowBox[{"Continue", "[", "]"}]}], "]"}], ";", 
                    "\[IndentingNewLine]", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"StringFreeQ", "[", 
                    RowBox[{
                    RowBox[{"baza", "[", 
                    RowBox[{"[", 
                    RowBox[{"j", ",", "2"}], "]"}], "]"}], ",", 
                    "\"\<sulfo\>\""}], "]"}], "&&", 
                    RowBox[{"!", 
                    RowBox[{"StringFreeQ", "[", 
                    RowBox[{
                    RowBox[{"baza1", "[", 
                    RowBox[{"[", 
                    RowBox[{"w", ",", "2"}], "]"}], "]"}], ",", 
                    "\"\<sulfo\>\""}], "]"}]}]}], ",", 
                    RowBox[{"Continue", "[", "]"}]}], "]"}], ";", 
                    "\[IndentingNewLine]", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"StringFreeQ", "[", 
                    RowBox[{
                    RowBox[{"baza", "[", 
                    RowBox[{"[", 
                    RowBox[{"j", ",", "2"}], "]"}], "]"}], ",", 
                    "\"\<Fuc\>\""}], "]"}], "&&", 
                    RowBox[{"!", 
                    RowBox[{"StringFreeQ", "[", 
                    RowBox[{
                    RowBox[{"baza1", "[", 
                    RowBox[{"[", 
                    RowBox[{"w", ",", "2"}], "]"}], "]"}], ",", 
                    "\"\<Fuc\>\""}], "]"}]}]}], ",", 
                    RowBox[{"Continue", "[", "]"}]}], "]"}], ";", 
                    "\[IndentingNewLine]", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"StringFreeQ", "[", 
                    RowBox[{
                    RowBox[{"baza", "[", 
                    RowBox[{"[", 
                    RowBox[{"j", ",", "2"}], "]"}], "]"}], ",", 
                    "\"\<GlcA\>\""}], "]"}], "&&", 
                    RowBox[{"!", 
                    RowBox[{"StringFreeQ", "[", 
                    RowBox[{
                    RowBox[{"baza1", "[", 
                    RowBox[{"[", 
                    RowBox[{"w", ",", "2"}], "]"}], "]"}], ",", 
                    "\"\<GlcA\>\""}], "]"}]}]}], ",", 
                    RowBox[{"Continue", "[", "]"}]}], "]"}], ";", 
                    "\[IndentingNewLine]", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"StringFreeQ", "[", 
                    RowBox[{
                    RowBox[{"baza", "[", 
                    RowBox[{"[", 
                    RowBox[{"j", ",", "2"}], "]"}], "]"}], ",", 
                    "\"\<OAc\>\""}], "]"}], "&&", 
                    RowBox[{"!", 
                    RowBox[{"StringFreeQ", "[", 
                    RowBox[{
                    RowBox[{"baza1", "[", 
                    RowBox[{"[", 
                    RowBox[{"w", ",", "2"}], "]"}], "]"}], ",", 
                    "\"\<OAc\>\""}], "]"}]}]}], ",", 
                    RowBox[{"Continue", "[", "]"}]}], "]"}], ";", 
                    "\[IndentingNewLine]", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"!", 
                    RowBox[{"StringFreeQ", "[", 
                    RowBox[{
                    RowBox[{"baza", "[", 
                    RowBox[{"[", 
                    RowBox[{"j", ",", "2"}], "]"}], "]"}], ",", 
                    "\"\<OAc\>\""}], "]"}]}], "&&", 
                    RowBox[{"StringFreeQ", "[", 
                    RowBox[{
                    RowBox[{"baza", "[", 
                    RowBox[{"[", 
                    RowBox[{"j", ",", "2"}], "]"}], "]"}], ",", 
                    "\"\<2*OAc\>\""}], "]"}], "&&", 
                    RowBox[{"!", 
                    RowBox[{"StringFreeQ", "[", 
                    RowBox[{
                    RowBox[{"baza1", "[", 
                    RowBox[{"[", 
                    RowBox[{"w", ",", "2"}], "]"}], "]"}], ",", 
                    "\"\<2*OAc\>\""}], "]"}]}]}], ",", 
                    RowBox[{"Continue", "[", "]"}]}], "]"}], ";", 
                    "\[IndentingNewLine]", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"StringFreeQ", "[", 
                    RowBox[{
                    RowBox[{"baza", "[", 
                    RowBox[{"[", 
                    RowBox[{"j", ",", "2"}], "]"}], "]"}], ",", 
                    "\"\<Hex\>\""}], "]"}], "&&", 
                    RowBox[{"!", 
                    RowBox[{"StringFreeQ", "[", 
                    RowBox[{
                    RowBox[{"baza1", "[", 
                    RowBox[{"[", 
                    RowBox[{"w", ",", "2"}], "]"}], "]"}], ",", 
                    "\"\<Hex\>\""}], "]"}]}]}], ",", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"StringFreeQ", "[", 
                    RowBox[{
                    RowBox[{"baza1", "[", 
                    RowBox[{"[", 
                    RowBox[{"w", ",", "2"}], "]"}], "]"}], ",", 
                    "\"\<HexCer\>\""}], "]"}], ",", 
                    RowBox[{"Continue", "[", "]"}]}], "]"}]}], "]"}], ";", 
                    "\[IndentingNewLine]", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"StringFreeQ", "[", 
                    RowBox[{
                    RowBox[{"baza", "[", 
                    RowBox[{"[", 
                    RowBox[{"j", ",", "2"}], "]"}], "]"}], ",", 
                    "\"\<HexNAc\>\""}], "]"}], "&&", 
                    RowBox[{"!", 
                    RowBox[{"StringFreeQ", "[", 
                    RowBox[{
                    RowBox[{"baza1", "[", 
                    RowBox[{"[", 
                    RowBox[{"w", ",", "2"}], "]"}], "]"}], ",", 
                    "\"\<HexNAc\>\""}], "]"}]}]}], ",", 
                    RowBox[{"Continue", "[", "]"}]}], "]"}], ";", 
                    "\[IndentingNewLine]", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"!", 
                    RowBox[{"StringFreeQ", "[", 
                    RowBox[{
                    RowBox[{"baza", "[", 
                    RowBox[{"[", 
                    RowBox[{"j", ",", "2"}], "]"}], "]"}], ",", 
                    "\"\<HexNAc\>\""}], "]"}]}], "&&", 
                    RowBox[{"!", 
                    RowBox[{"StringFreeQ", "[", 
                    RowBox[{
                    RowBox[{"baza1", "[", 
                    RowBox[{"[", 
                    RowBox[{"w", ",", "2"}], "]"}], "]"}], ",", 
                    "\"\<Hex G\>\""}], "]"}]}]}], ",", 
                    RowBox[{"Continue", "[", "]"}]}], "]"}], ";", 
                    "\[IndentingNewLine]", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"StringFreeQ", "[", 
                    RowBox[{
                    RowBox[{"baza", "[", 
                    RowBox[{"[", 
                    RowBox[{"j", ",", "2"}], "]"}], "]"}], ",", 
                    "\"\<de-N-Ac\>\""}], "]"}], "&&", 
                    RowBox[{"!", 
                    RowBox[{"StringFreeQ", "[", 
                    RowBox[{
                    RowBox[{"baza1", "[", 
                    RowBox[{"[", 
                    RowBox[{"w", ",", "2"}], "]"}], "]"}], ",", 
                    "\"\<de-N-Ac\>\""}], "]"}]}]}], ",", 
                    RowBox[{"Continue", "[", "]"}]}], "]"}], ";", 
                    "\[IndentingNewLine]", "\[IndentingNewLine]", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"!", 
                    RowBox[{"StringFreeQ", "[", 
                    RowBox[{
                    RowBox[{"baza", "[", 
                    RowBox[{"[", 
                    RowBox[{"j", ",", "2"}], "]"}], "]"}], ",", 
                    RowBox[{"{", 
                    RowBox[{
                    "\"\<GM1(\>\"", ",", "\"\<GM2(\>\"", ",", 
                    "\"\<GM3(\>\""}], "}"}]}], "]"}]}], "&&", 
                    RowBox[{"StringFreeQ", "[", 
                    RowBox[{
                    RowBox[{"baza1", "[", 
                    RowBox[{"[", 
                    RowBox[{"w", ",", "2"}], "]"}], "]"}], ",", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"\"\<GM\>\"", "~~", "_", "~~", "\"\<(\>\""}], 
                    ",", "\"\<Gg\>\"", ",", "\"\<HexCer\>\"", ",", 
                    "\"\<LacCer\>\""}], "}"}]}], "]"}]}], ",", 
                    RowBox[{"Continue", "[", "]"}]}], "]"}], ";", 
                    "\[IndentingNewLine]", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"!", 
                    RowBox[{"StringFreeQ", "[", 
                    RowBox[{
                    RowBox[{"baza", "[", 
                    RowBox[{"[", 
                    RowBox[{"j", ",", "2"}], "]"}], "]"}], ",", 
                    RowBox[{"{", 
                    RowBox[{
                    "\"\<GD1(\>\"", ",", "\"\<GD2(\>\"", ",", 
                    "\"\<GD3(\>\""}], "}"}]}], "]"}]}], "&&", 
                    RowBox[{"StringFreeQ", "[", 
                    RowBox[{
                    RowBox[{"baza1", "[", 
                    RowBox[{"[", 
                    RowBox[{"w", ",", "2"}], "]"}], "]"}], ",", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"\"\<GD\>\"", "~~", "_", "~~", "\"\<(\>\""}], ",", 
                    RowBox[{"\"\<GM\>\"", "~~", "_", "~~", "\"\<(\>\""}], 
                    ",", "\"\<Gg\>\"", ",", "\"\<HexCer\>\"", ",", 
                    "\"\<LacCer\>\""}], "}"}]}], "]"}]}], ",", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"!", 
                    RowBox[{"StringFreeQ", "[", 
                    RowBox[{
                    RowBox[{"baza", "[", 
                    RowBox[{"[", 
                    RowBox[{"j", ",", "2"}], "]"}], "]"}], ",", 
                    "\"\<NeuAc\>\""}], "]"}]}], "&&", 
                    RowBox[{"!", 
                    RowBox[{"StringFreeQ", "[", 
                    RowBox[{
                    RowBox[{"baza1", "[", 
                    RowBox[{"[", 
                    RowBox[{"w", ",", "2"}], "]"}], "]"}], ",", 
                    "\"\<GM\>\""}], "]"}]}]}], ",", ",", 
                    RowBox[{"Continue", "[", "]"}]}], "]"}]}], "]"}], ";", 
                    "\[IndentingNewLine]", "\[IndentingNewLine]", 
                    StyleBox[
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"!", 
                    RowBox[{"StringFreeQ", "[", 
                    RowBox[{
                    RowBox[{"baza", "[", 
                    RowBox[{"[", 
                    RowBox[{"j", ",", "2"}], "]"}], "]"}], ",", 
                    "\"\<KDNKDN\>\""}], "]"}]}], "&&", 
                    RowBox[{"!", 
                    RowBox[{"StringFreeQ", "[", 
                    RowBox[{
                    RowBox[{"baza1", "[", 
                    RowBox[{"[", 
                    RowBox[{"w", ",", "2"}], "]"}], "]"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"\"\<NeuAc\>\"", ",", "\"\<NeuGc\>\""}], "}"}]}], 
                    "]"}]}]}], ",", 
                    RowBox[{"Continue", "[", "]"}]}], "]"}],
                    Background->RGBColor[0.87, 0.94, 1]], 
                    StyleBox[";",
                    Background->RGBColor[0.87, 0.94, 1]], 
                    StyleBox["\[IndentingNewLine]",
                    Background->RGBColor[0.87, 0.94, 1]], 
                    StyleBox[
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"!", 
                    RowBox[{"StringFreeQ", "[", 
                    RowBox[{
                    RowBox[{"baza", "[", 
                    RowBox[{"[", 
                    RowBox[{"j", ",", "2"}], "]"}], "]"}], ",", 
                    "\"\<NeuGcNeuGc\>\""}], "]"}]}], "&&", 
                    RowBox[{"!", 
                    RowBox[{"StringFreeQ", "[", 
                    RowBox[{
                    RowBox[{"baza1", "[", 
                    RowBox[{"[", 
                    RowBox[{"w", ",", "2"}], "]"}], "]"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"\"\<NeuAc\>\"", ",", "\"\<KDN\>\""}], "}"}]}], 
                    "]"}]}]}], ",", 
                    RowBox[{"Continue", "[", "]"}]}], "]"}],
                    Background->RGBColor[0.87, 0.94, 1]], 
                    StyleBox[";",
                    Background->RGBColor[0.87, 0.94, 1]], 
                    StyleBox["\[IndentingNewLine]",
                    Background->RGBColor[0.87, 0.94, 1]], 
                    StyleBox[
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"!", 
                    RowBox[{"StringFreeQ", "[", 
                    RowBox[{
                    RowBox[{"baza", "[", 
                    RowBox[{"[", 
                    RowBox[{"j", ",", "2"}], "]"}], "]"}], ",", 
                    "\"\<NeuAcNeuGc\>\""}], "]"}]}], "&&", 
                    RowBox[{"!", 
                    RowBox[{"StringFreeQ", "[", 
                    RowBox[{
                    RowBox[{"baza1", "[", 
                    RowBox[{"[", 
                    RowBox[{"w", ",", "2"}], "]"}], "]"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"\"\<NeuGcNeuGc\>\"", ",", "\"\<NeuGcKDN\>\""}], 
                    "}"}]}], "]"}]}]}], ",", 
                    RowBox[{"Continue", "[", "]"}]}], "]"}],
                    Background->RGBColor[0.87, 0.94, 1]], 
                    StyleBox[";",
                    Background->RGBColor[0.87, 0.94, 1]], 
                    StyleBox["\[IndentingNewLine]",
                    Background->RGBColor[0.87, 0.94, 1]], 
                    StyleBox[
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"!", 
                    RowBox[{"StringFreeQ", "[", 
                    RowBox[{
                    RowBox[{"baza", "[", 
                    RowBox[{"[", 
                    RowBox[{"j", ",", "2"}], "]"}], "]"}], ",", 
                    "\"\<NeuAcKDN\>\""}], "]"}]}], "&&", 
                    RowBox[{"!", 
                    RowBox[{"StringFreeQ", "[", 
                    RowBox[{
                    RowBox[{"baza1", "[", 
                    RowBox[{"[", 
                    RowBox[{"w", ",", "2"}], "]"}], "]"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"\"\<KDNKDN\>\"", ",", "\"\<NeuGcKDN\>\""}], 
                    "}"}]}], "]"}]}]}], ",", 
                    RowBox[{"Continue", "[", "]"}]}], "]"}],
                    Background->RGBColor[0.87, 0.94, 1]], 
                    StyleBox[";",
                    Background->RGBColor[0.87, 0.94, 1]], 
                    StyleBox["\[IndentingNewLine]",
                    Background->RGBColor[0.87, 0.94, 1]], 
                    StyleBox[
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"!", 
                    RowBox[{"StringFreeQ", "[", 
                    RowBox[{
                    RowBox[{"baza", "[", 
                    RowBox[{"[", 
                    RowBox[{"j", ",", "2"}], "]"}], "]"}], ",", 
                    "\"\<NeuGcKDN\>\""}], "]"}]}], "&&", 
                    RowBox[{"!", 
                    RowBox[{"StringFreeQ", "[", 
                    RowBox[{
                    RowBox[{"baza1", "[", 
                    RowBox[{"[", 
                    RowBox[{"w", ",", "2"}], "]"}], "]"}], ",", 
                    RowBox[{"{", 
                    RowBox[{
                    "\"\<KDNKDN\>\"", ",", "\"\<NeuAcKDN\>\"", ",", 
                    "\"\<NeuGcNeuGc\>\"", ",", "\"\<NeuAcNeuGc\>\""}], 
                    "}"}]}], "]"}]}]}], ",", 
                    RowBox[{"Continue", "[", "]"}]}], "]"}],
                    Background->RGBColor[0.87, 0.94, 1]], 
                    StyleBox[";",
                    Background->RGBColor[0.87, 0.94, 1]], 
                    "\[IndentingNewLine]", "\[IndentingNewLine]", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"!", 
                    RowBox[{"StringFreeQ", "[", 
                    RowBox[{
                    RowBox[{"baza", "[", 
                    RowBox[{"[", 
                    RowBox[{"j", ",", "2"}], "]"}], "]"}], ",", 
                    "\"\<GP\>\""}], "]"}]}], "&&", 
                    RowBox[{"!", 
                    RowBox[{"StringFreeQ", "[", 
                    RowBox[{
                    RowBox[{"baza1", "[", 
                    RowBox[{"[", 
                    RowBox[{"w", ",", "2"}], "]"}], "]"}], ",", 
                    "\"\<GH\>\""}], "]"}]}]}], ",", 
                    RowBox[{"Continue", "[", "]"}]}], "]"}], ";", 
                    "\[IndentingNewLine]", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"!", 
                    RowBox[{"StringFreeQ", "[", 
                    RowBox[{
                    RowBox[{"baza", "[", 
                    RowBox[{"[", 
                    RowBox[{"j", ",", "2"}], "]"}], "]"}], ",", 
                    "\"\<GQ\>\""}], "]"}]}], "&&", 
                    RowBox[{"!", 
                    RowBox[{"StringFreeQ", "[", 
                    RowBox[{
                    RowBox[{"baza1", "[", 
                    RowBox[{"[", 
                    RowBox[{"w", ",", "2"}], "]"}], "]"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"\"\<GH\>\"", ",", "\"\<GP\>\""}], "}"}]}], 
                    "]"}]}]}], ",", 
                    RowBox[{"Continue", "[", "]"}]}], "]"}], ";", 
                    "\[IndentingNewLine]", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"!", 
                    RowBox[{"StringFreeQ", "[", 
                    RowBox[{
                    RowBox[{"baza", "[", 
                    RowBox[{"[", 
                    RowBox[{"j", ",", "2"}], "]"}], "]"}], ",", 
                    "\"\<GT\>\""}], "]"}]}], "&&", 
                    RowBox[{"!", 
                    RowBox[{"StringFreeQ", "[", 
                    RowBox[{
                    RowBox[{"baza1", "[", 
                    RowBox[{"[", 
                    RowBox[{"w", ",", "2"}], "]"}], "]"}], ",", 
                    RowBox[{"{", 
                    RowBox[{
                    "\"\<GH\>\"", ",", "\"\<GP\>\"", ",", "\"\<GQ\>\""}], 
                    "}"}]}], "]"}]}]}], ",", 
                    RowBox[{"Continue", "[", "]"}]}], "]"}], ";", 
                    "\[IndentingNewLine]", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"!", 
                    RowBox[{"StringFreeQ", "[", 
                    RowBox[{
                    RowBox[{"baza", "[", 
                    RowBox[{"[", 
                    RowBox[{"j", ",", "2"}], "]"}], "]"}], ",", 
                    "\"\<GD\>\""}], "]"}]}], "&&", 
                    RowBox[{"!", 
                    RowBox[{"StringFreeQ", "[", 
                    RowBox[{
                    RowBox[{"baza1", "[", 
                    RowBox[{"[", 
                    RowBox[{"w", ",", "2"}], "]"}], "]"}], ",", 
                    RowBox[{"{", 
                    RowBox[{
                    "\"\<GT\>\"", ",", "\"\<GH\>\"", ",", "\"\<GP\>\"", ",", 
                    "\"\<GQ\>\""}], "}"}]}], "]"}]}]}], ",", 
                    RowBox[{"Continue", "[", "]"}]}], "]"}], ";", 
                    "\[IndentingNewLine]", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"!", 
                    RowBox[{"StringFreeQ", "[", 
                    RowBox[{
                    RowBox[{"baza", "[", 
                    RowBox[{"[", 
                    RowBox[{"j", ",", "2"}], "]"}], "]"}], ",", 
                    "\"\<GM\>\""}], "]"}]}], "&&", 
                    RowBox[{"!", 
                    RowBox[{"StringFreeQ", "[", 
                    RowBox[{
                    RowBox[{"baza1", "[", 
                    RowBox[{"[", 
                    RowBox[{"w", ",", "2"}], "]"}], "]"}], ",", 
                    RowBox[{"{", 
                    RowBox[{
                    "\"\<GT\>\"", ",", "\"\<GH\>\"", ",", "\"\<GP\>\"", ",", 
                    "\"\<GQ\>\"", ",", "\"\<GD\>\""}], "}"}]}], "]"}]}]}], 
                    ",", 
                    RowBox[{"Continue", "[", "]"}]}], "]"}], ";", 
                    "\[IndentingNewLine]", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"!", 
                    RowBox[{"StringFreeQ", "[", 
                    RowBox[{
                    RowBox[{"baza", "[", 
                    RowBox[{"[", 
                    RowBox[{"j", ",", "2"}], "]"}], "]"}], ",", 
                    "\"\<Gg\>\""}], "]"}]}], "&&", 
                    RowBox[{"!", 
                    RowBox[{"StringFreeQ", "[", 
                    RowBox[{
                    RowBox[{"baza1", "[", 
                    RowBox[{"[", 
                    RowBox[{"w", ",", "2"}], "]"}], "]"}], ",", 
                    RowBox[{"{", 
                    RowBox[{
                    "\"\<GT\>\"", ",", "\"\<GH\>\"", ",", "\"\<GP\>\"", ",", 
                    "\"\<GQ\>\"", ",", "\"\<GD\>\"", ",", "\"\<GM\>\""}], 
                    "}"}]}], "]"}]}]}], ",", 
                    RowBox[{"Continue", "[", "]"}]}], "]"}], ";", 
                    "\[IndentingNewLine]", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"!", 
                    RowBox[{"StringFreeQ", "[", 
                    RowBox[{
                    RowBox[{"baza", "[", 
                    RowBox[{"[", 
                    RowBox[{"j", ",", "2"}], "]"}], "]"}], ",", 
                    RowBox[{"{", 
                    RowBox[{
                    "\"\<GM3\>\"", ",", "\"\<GD3\>\"", ",", "\"\<GT3\>\"", 
                    ",", "\"\<GQ3\>\""}], "}"}]}], "]"}]}], "&&", 
                    RowBox[{"!", 
                    RowBox[{"StringFreeQ", "[", 
                    RowBox[{
                    RowBox[{"baza1", "[", 
                    RowBox[{"[", 
                    RowBox[{"w", ",", "2"}], "]"}], "]"}], ",", 
                    "\"\<Gg\>\""}], "]"}]}]}], ",", 
                    RowBox[{"Continue", "[", "]"}]}], "]"}], ";", 
                    "\[IndentingNewLine]", "\[IndentingNewLine]", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{"dataD0", "[", 
                    RowBox[{"[", 
                    RowBox[{"i", ",", "z"}], "]"}], "]"}], "-", "ToleMSMS"}], 
                    "\[LessEqual]", 
                    RowBox[{"baza1", "[", 
                    RowBox[{"[", 
                    RowBox[{"w", ",", "1"}], "]"}], "]"}], "\[LessEqual]", 
                    RowBox[{
                    RowBox[{"dataD0", "[", 
                    RowBox[{"[", 
                    RowBox[{"i", ",", "z"}], "]"}], "]"}], "+", 
                    "ToleMSMS"}]}], ",", 
                    RowBox[{
                    RowBox[{"c", "=", 
                    RowBox[{"Append", "[", 
                    RowBox[{"c", ",", 
                    RowBox[{
                    RowBox[{"dataD0", "[", 
                    RowBox[{"[", 
                    RowBox[{"i", ",", "z"}], "]"}], "]"}], "-", 
                    RowBox[{"baza1", "[", 
                    RowBox[{"[", 
                    RowBox[{"w", ",", "2"}], "]"}], "]"}]}]}], "]"}]}], ";", 
                    StyleBox[
                    RowBox[{"Break", "[", "]"}],
                    Background->RGBColor[1, 0.5, 0]]}], ",", 
                    "\[IndentingNewLine]", 
                    RowBox[{"e", "=", 
                    RowBox[{"Append", "[", 
                    RowBox[{"e", ",", 
                    RowBox[{
                    RowBox[{"dataD0", "[", 
                    RowBox[{"[", 
                    RowBox[{"i", ",", "z"}], "]"}], "]"}], "-", 
                    RowBox[{"baza1", "[", 
                    RowBox[{"[", 
                    RowBox[{"w", ",", "2"}], "]"}], "]"}]}]}], "]"}]}]}], 
                    "]"}], ";"}]}], "\[IndentingNewLine]", 
                   "\[IndentingNewLine]", "]"}], ",", "\[IndentingNewLine]", 
                  RowBox[{"{", 
                   RowBox[{"w", ",", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"LengthWhile", "[", 
                    RowBox[{"baza1", ",", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"#", "[", 
                    RowBox[{"[", "1", "]"}], "]"}], "<", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"dataD0", "[", 
                    RowBox[{"[", 
                    RowBox[{"i", ",", "z"}], "]"}], "]"}], "-", "1"}], 
                    ")"}]}], "&"}]}], "]"}], "+", "1"}], ")"}], ",", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"LengthWhile", "[", 
                    RowBox[{"baza1", ",", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"#", "[", 
                    RowBox[{"[", "1", "]"}], "]"}], "<", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"dataD0", "[", 
                    RowBox[{"[", 
                    RowBox[{"i", ",", "z"}], "]"}], "]"}], "+", "19"}], 
                    ")"}]}], "&"}]}], "]"}], "+", "1"}], ")"}]}], "}"}]}], 
                 "]"}], ";", "\[IndentingNewLine]", "\[IndentingNewLine]", 
                "\[IndentingNewLine]", "\[IndentingNewLine]", 
                RowBox[{"Do", "[", " ", 
                 RowBox[{
                  RowBox[{"If", "[", 
                   RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{"dataD0", "[", 
                    RowBox[{"[", 
                    RowBox[{"i", ",", "z"}], "]"}], "]"}], "-", "ToleMSMS"}], 
                    "\[LessEqual]", 
                    RowBox[{"cer", "[", 
                    RowBox[{"[", 
                    RowBox[{"w", ",", "1"}], "]"}], "]"}], "\[LessEqual]", 
                    RowBox[{
                    RowBox[{"dataD0", "[", 
                    RowBox[{"[", 
                    RowBox[{"i", ",", "z"}], "]"}], "]"}], "+", 
                    "ToleMSMS"}]}], ",", " ", "\[IndentingNewLine]", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"cer", "[", 
                    RowBox[{"[", 
                    RowBox[{"w", ",", 
                    RowBox[{"-", "1"}]}], "]"}], "]"}], "==", 
                    RowBox[{"baza", "[", 
                    RowBox[{"[", 
                    RowBox[{"j", ",", 
                    RowBox[{"-", "1"}]}], "]"}], "]"}]}], ",", 
                    RowBox[{"c", "=", 
                    RowBox[{"Append", "[", 
                    RowBox[{"c", ",", 
                    RowBox[{
                    RowBox[{"dataD0", "[", 
                    RowBox[{"[", 
                    RowBox[{"i", ",", "z"}], "]"}], "]"}], "-", 
                    RowBox[{"cer", "[", 
                    RowBox[{"[", 
                    RowBox[{"w", ",", 
                    RowBox[{"-", "1"}]}], "]"}], "]"}]}]}], "]"}]}]}], 
                    "]"}]}], "]"}], ",", "\[IndentingNewLine]", 
                  RowBox[{"{", 
                   RowBox[{"w", ",", "1", ",", 
                    RowBox[{"Length", "[", "cer", "]"}]}], "}"}]}], "]"}], 
                ";", "\[IndentingNewLine]", "\[IndentingNewLine]", 
                "\[IndentingNewLine]", 
                RowBox[{"If", "[", 
                 RowBox[{
                  RowBox[{"!", 
                   RowBox[{"StringFreeQ", "[", 
                    RowBox[{
                    RowBox[{"baza", "[", 
                    RowBox[{"[", 
                    RowBox[{"j", ",", "2"}], "]"}], "]"}], ",", 
                    RowBox[{"{", 
                    RowBox[{
                    "\"\<GM4\>\"", ",", "\"\<Gg\>\"", ",", "\"\<LacCer\>\"", 
                    ",", "\"\<HexCer\>\""}], "}"}]}], "]"}]}], " ", ",", " ", 
                  ",", "\[IndentingNewLine]", "\[IndentingNewLine]", 
                  RowBox[{
                   RowBox[{"Do", "[", " ", 
                    RowBox[{
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{"dataD0", "[", 
                    RowBox[{"[", 
                    RowBox[{"i", ",", "z"}], "]"}], "]"}], "-", "ToleMSMS"}], 
                    "\[LessEqual]", 
                    RowBox[{"bazaSA", "[", 
                    RowBox[{"[", 
                    RowBox[{"w", ",", "1"}], "]"}], "]"}], "\[LessEqual]", 
                    RowBox[{
                    RowBox[{"dataD0", "[", 
                    RowBox[{"[", 
                    RowBox[{"i", ",", "z"}], "]"}], "]"}], "+", 
                    "ToleMSMS"}]}], ",", " ", "\[IndentingNewLine]", 
                    RowBox[{
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"!", 
                    RowBox[{"StringFreeQ", "[", 
                    RowBox[{
                    RowBox[{"baza", "[", 
                    RowBox[{"[", 
                    RowBox[{"j", ",", "2"}], "]"}], "]"}], ",", 
                    RowBox[{"{", 
                    RowBox[{
                    "\"\<GM1(\>\"", ",", "\"\<GM2(\>\"", ",", 
                    "\"\<GM3(\>\""}], "}"}]}], "]"}]}], "&&", 
                    RowBox[{"!", 
                    RowBox[{"StringFreeQ", "[", 
                    RowBox[{
                    RowBox[{"bazaSA", "[", 
                    RowBox[{"[", 
                    RowBox[{"w", ",", "2"}], "]"}], "]"}], ",", 
                    "\"\<NeuAc\>\""}], "]"}]}]}], ",", 
                    RowBox[{"Continue", "[", "]"}]}], "]"}], ";", 
                    "\[IndentingNewLine]", 
                    StyleBox[
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"!", 
                    RowBox[{"StringFreeQ", "[", 
                    RowBox[{
                    RowBox[{"baza", "[", 
                    RowBox[{"[", 
                    RowBox[{"j", ",", "2"}], "]"}], "]"}], ",", 
                    "\"\<LD\>\""}], "]"}]}], "&&", 
                    RowBox[{"!", 
                    RowBox[{"StringFreeQ", "[", 
                    RowBox[{
                    RowBox[{"bazaSA", "[", 
                    RowBox[{"[", 
                    RowBox[{"w", ",", "2"}], "]"}], "]"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"\"\<NeuGc\>\"", ",", "\"\<KDN\>\""}], "}"}]}], 
                    "]"}]}]}], ",", 
                    RowBox[{"Continue", "[", "]"}]}], "]"}],
                    Background->RGBColor[1, 0.85, 0.85]], 
                    StyleBox[";",
                    Background->RGBColor[1, 0.85, 0.85]], 
                    "\[IndentingNewLine]", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"!", 
                    RowBox[{"StringFreeQ", "[", 
                    RowBox[{
                    RowBox[{"baza", "[", 
                    RowBox[{"[", 
                    RowBox[{"j", ",", "2"}], "]"}], "]"}], ",", 
                    "\"\<GM\>\""}], "]"}]}], "&&", 
                    RowBox[{"!", 
                    RowBox[{"StringFreeQ", "[", 
                    RowBox[{
                    RowBox[{"bazaSA", "[", 
                    RowBox[{"[", 
                    RowBox[{"w", ",", "2"}], "]"}], "]"}], ",", "\"\<*\>\""}],
                     "]"}]}]}], ",", 
                    RowBox[{"Continue", "[", "]"}]}], "]"}], ";", 
                    "\[IndentingNewLine]", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"StringFreeQ", "[", 
                    RowBox[{
                    RowBox[{"baza", "[", 
                    RowBox[{"[", 
                    RowBox[{"j", ",", "2"}], "]"}], "]"}], ",", 
                    "\"\<KDN\>\""}], "]"}], "&&", 
                    RowBox[{"!", 
                    RowBox[{"StringFreeQ", "[", 
                    RowBox[{
                    RowBox[{"bazaSA", "[", 
                    RowBox[{"[", 
                    RowBox[{"w", ",", "2"}], "]"}], "]"}], ",", 
                    "\"\<KDN\>\""}], "]"}]}]}], ",", 
                    RowBox[{"Continue", "[", "]"}]}], "]"}], ";", 
                    "\[IndentingNewLine]", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"StringFreeQ", "[", 
                    RowBox[{
                    RowBox[{"baza", "[", 
                    RowBox[{"[", 
                    RowBox[{"j", ",", "2"}], "]"}], "]"}], ",", 
                    "\"\<NeuGc\>\""}], "]"}], "&&", 
                    RowBox[{"!", 
                    RowBox[{"StringFreeQ", "[", 
                    RowBox[{
                    RowBox[{"bazaSA", "[", 
                    RowBox[{"[", 
                    RowBox[{"w", ",", "2"}], "]"}], "]"}], ",", 
                    "\"\<NeuGc\>\""}], "]"}]}]}], ",", 
                    RowBox[{"Continue", "[", "]"}]}], "]"}], ";", 
                    "\[IndentingNewLine]", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"!", 
                    RowBox[{"StringFreeQ", "[", 
                    RowBox[{
                    RowBox[{"baza", "[", 
                    RowBox[{"[", 
                    RowBox[{"j", ",", "2"}], "]"}], "]"}], ",", 
                    "\"\<NeuAc\>\""}], "]"}]}], "&&", 
                    RowBox[{"!", 
                    RowBox[{"StringFreeQ", "[", 
                    RowBox[{
                    RowBox[{"bazaSA", "[", 
                    RowBox[{"[", 
                    RowBox[{"w", ",", "2"}], "]"}], "]"}], ",", 
                    "\"\<*NeuAc\>\""}], "]"}]}]}], ",", 
                    RowBox[{"Continue", "[", "]"}]}], "]"}], ";", 
                    "\[IndentingNewLine]", "\[IndentingNewLine]", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"!", 
                    RowBox[{"StringFreeQ", "[", 
                    RowBox[{
                    RowBox[{"baza", "[", 
                    RowBox[{"[", 
                    RowBox[{"j", ",", "2"}], "]"}], "]"}], ",", 
                    "\"\<KDNKDN\>\""}], "]"}]}], "&&", 
                    RowBox[{"!", 
                    RowBox[{"StringFreeQ", "[", 
                    RowBox[{
                    RowBox[{"bazaSA", "[", 
                    RowBox[{"[", 
                    RowBox[{"w", ",", "2"}], "]"}], "]"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"\"\<NeuAc\>\"", ",", "\"\<NeuGc\>\""}], "}"}]}], 
                    "]"}]}]}], ",", 
                    RowBox[{"Continue", "[", "]"}]}], "]"}], ";", 
                    "\[IndentingNewLine]", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"!", 
                    RowBox[{"StringFreeQ", "[", 
                    RowBox[{
                    RowBox[{"baza", "[", 
                    RowBox[{"[", 
                    RowBox[{"j", ",", "2"}], "]"}], "]"}], ",", 
                    "\"\<NeuGcNeuGc\>\""}], "]"}]}], "&&", 
                    RowBox[{"!", 
                    RowBox[{"StringFreeQ", "[", 
                    RowBox[{
                    RowBox[{"bazaSA", "[", 
                    RowBox[{"[", 
                    RowBox[{"w", ",", "2"}], "]"}], "]"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"\"\<NeuAc\>\"", ",", "\"\<KDN\>\""}], "}"}]}], 
                    "]"}]}]}], ",", 
                    RowBox[{"Continue", "[", "]"}]}], "]"}], ";", 
                    "\[IndentingNewLine]", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"!", 
                    RowBox[{"StringFreeQ", "[", 
                    RowBox[{
                    RowBox[{"baza", "[", 
                    RowBox[{"[", 
                    RowBox[{"j", ",", "2"}], "]"}], "]"}], ",", 
                    "\"\<NeuAcNeuGc\>\""}], "]"}]}], "&&", 
                    RowBox[{"!", 
                    RowBox[{"StringFreeQ", "[", 
                    RowBox[{
                    RowBox[{"bazaSA", "[", 
                    RowBox[{"[", 
                    RowBox[{"w", ",", "2"}], "]"}], "]"}], ",", 
                    RowBox[{"{", 
                    RowBox[{
                    "\"\<NeuGc_NeuGc\>\"", ",", "\"\<KDN\>\"", ",", 
                    "\"\<*NeuAc\>\""}], "}"}]}], "]"}]}]}], ",", 
                    RowBox[{"Continue", "[", "]"}]}], "]"}], ";", 
                    "\[IndentingNewLine]", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"!", 
                    RowBox[{"StringFreeQ", "[", 
                    RowBox[{
                    RowBox[{"baza", "[", 
                    RowBox[{"[", 
                    RowBox[{"j", ",", "2"}], "]"}], "]"}], ",", 
                    "\"\<NeuAcKDN\>\""}], "]"}]}], "&&", 
                    RowBox[{"!", 
                    RowBox[{"StringFreeQ", "[", 
                    RowBox[{
                    RowBox[{"bazaSA", "[", 
                    RowBox[{"[", 
                    RowBox[{"w", ",", "2"}], "]"}], "]"}], ",", 
                    RowBox[{"{", 
                    RowBox[{
                    "\"\<KDN_KDN\>\"", ",", "\"\<NeuGc\>\"", ",", 
                    "\"\<*NeuAc\>\""}], "}"}]}], "]"}]}]}], ",", 
                    RowBox[{"Continue", "[", "]"}]}], "]"}], ";", 
                    "\[IndentingNewLine]", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"!", 
                    RowBox[{"StringFreeQ", "[", 
                    RowBox[{
                    RowBox[{"baza", "[", 
                    RowBox[{"[", 
                    RowBox[{"j", ",", "2"}], "]"}], "]"}], ",", 
                    "\"\<NeuGcKDN\>\""}], "]"}]}], "&&", 
                    RowBox[{"!", 
                    RowBox[{"StringFreeQ", "[", 
                    RowBox[{
                    RowBox[{"bazaSA", "[", 
                    RowBox[{"[", 
                    RowBox[{"w", ",", "2"}], "]"}], "]"}], ",", 
                    RowBox[{"{", 
                    RowBox[{
                    "\"\<KDN_KDN\>\"", ",", "\"\<NeuAc\>\"", ",", 
                    "\"\<NeuGc_NeuGc\>\""}], "}"}]}], "]"}]}]}], ",", 
                    RowBox[{"Continue", "[", "]"}]}], "]"}], ";", 
                    "\[IndentingNewLine]", "\[IndentingNewLine]", 
                    RowBox[{"d", "=", 
                    RowBox[{"Append", "[", 
                    RowBox[{"d", ",", 
                    RowBox[{
                    RowBox[{"dataD0", "[", 
                    RowBox[{"[", 
                    RowBox[{"i", ",", "z"}], "]"}], "]"}], "-", 
                    RowBox[{"bazaSA", "[", 
                    RowBox[{"[", 
                    RowBox[{"w", ",", 
                    RowBox[{"-", "1"}]}], "]"}], "]"}]}]}], "]"}]}]}]}], 
                    "]"}], ",", "\[IndentingNewLine]", 
                    RowBox[{"{", 
                    RowBox[{"w", ",", "1", ",", 
                    RowBox[{"Length", "[", "bazaSA", "]"}]}], "}"}]}], "]"}], 
                   ";", "\[IndentingNewLine]", "\[IndentingNewLine]", 
                   RowBox[{"Do", "[", " ", 
                    RowBox[{
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{"dataD0", "[", 
                    RowBox[{"[", 
                    RowBox[{"i", ",", "z"}], "]"}], "]"}], "-", "ToleMSMS"}], 
                    "\[LessEqual]", 
                    RowBox[{"bazaOAc", "[", 
                    RowBox[{"[", 
                    RowBox[{"w", ",", "1"}], "]"}], "]"}], "\[LessEqual]", 
                    RowBox[{
                    RowBox[{"dataD0", "[", 
                    RowBox[{"[", 
                    RowBox[{"i", ",", "z"}], "]"}], "]"}], "+", 
                    "ToleMSMS"}]}], "&&", 
                    RowBox[{"!", 
                    RowBox[{"StringFreeQ", "[", 
                    RowBox[{
                    RowBox[{"baza", "[", 
                    RowBox[{"[", 
                    RowBox[{"j", ",", "2"}], "]"}], "]"}], ",", 
                    "\"\<OAc\>\""}], "]"}]}]}], ",", " ", 
                    "\[IndentingNewLine]", 
                    RowBox[{
                    StyleBox[
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"!", 
                    RowBox[{"StringFreeQ", "[", 
                    RowBox[{
                    RowBox[{"baza", "[", 
                    RowBox[{"[", 
                    RowBox[{"j", ",", "2"}], "]"}], "]"}], ",", 
                    "\"\<LD\>\""}], "]"}]}], ",", 
                    RowBox[{"Continue", "[", "]"}]}], "]"}],
                    Background->RGBColor[1, 0.85, 0.85]], 
                    StyleBox[";",
                    Background->RGBColor[1, 0.85, 0.85]], 
                    "\[IndentingNewLine]", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"!", 
                    RowBox[{"StringFreeQ", "[", 
                    RowBox[{
                    RowBox[{"baza", "[", 
                    RowBox[{"[", 
                    RowBox[{"j", ",", "2"}], "]"}], "]"}], ",", 
                    RowBox[{"{", 
                    RowBox[{
                    "\"\<GM1(\>\"", ",", "\"\<GM2(\>\"", ",", 
                    "\"\<GM3(\>\""}], "}"}]}], "]"}]}], "&&", 
                    RowBox[{"!", 
                    RowBox[{"StringFreeQ", "[", 
                    RowBox[{
                    RowBox[{"bazaOAc", "[", 
                    RowBox[{"[", 
                    RowBox[{"w", ",", "2"}], "]"}], "]"}], ",", 
                    "\"\<NeuAc\>\""}], "]"}]}]}], ",", 
                    RowBox[{"Continue", "[", "]"}]}], "]"}], ";", 
                    "\[IndentingNewLine]", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"!", 
                    RowBox[{"StringFreeQ", "[", 
                    RowBox[{
                    RowBox[{"baza", "[", 
                    RowBox[{"[", 
                    RowBox[{"j", ",", "2"}], "]"}], "]"}], ",", 
                    "\"\<GM\>\""}], "]"}]}], "&&", 
                    RowBox[{"!", 
                    RowBox[{"StringFreeQ", "[", 
                    RowBox[{
                    RowBox[{"bazaOAc", "[", 
                    RowBox[{"[", 
                    RowBox[{"w", ",", "2"}], "]"}], "]"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"\"\<*NeuAc\>\"", ",", "\"\<(\>\""}], "}"}]}], 
                    "]"}]}]}], ",", 
                    RowBox[{"Continue", "[", "]"}]}], "]"}], ";", 
                    "\[IndentingNewLine]", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"StringFreeQ", "[", 
                    RowBox[{
                    RowBox[{"baza", "[", 
                    RowBox[{"[", 
                    RowBox[{"j", ",", "2"}], "]"}], "]"}], ",", 
                    "\"\<KDN\>\""}], "]"}], "&&", 
                    RowBox[{"!", 
                    RowBox[{"StringFreeQ", "[", 
                    RowBox[{
                    RowBox[{"bazaOAc", "[", 
                    RowBox[{"[", 
                    RowBox[{"w", ",", "2"}], "]"}], "]"}], ",", 
                    "\"\<KDN\>\""}], "]"}]}]}], ",", 
                    RowBox[{"Continue", "[", "]"}]}], "]"}], ";", 
                    "\[IndentingNewLine]", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"StringFreeQ", "[", 
                    RowBox[{
                    RowBox[{"baza", "[", 
                    RowBox[{"[", 
                    RowBox[{"j", ",", "2"}], "]"}], "]"}], ",", 
                    "\"\<NeuGc\>\""}], "]"}], "&&", 
                    RowBox[{"!", 
                    RowBox[{"StringFreeQ", "[", 
                    RowBox[{
                    RowBox[{"bazaOAc", "[", 
                    RowBox[{"[", 
                    RowBox[{"w", ",", "2"}], "]"}], "]"}], ",", 
                    "\"\<NeuGc\>\""}], "]"}]}]}], ",", 
                    RowBox[{"Continue", "[", "]"}]}], "]"}], ";", 
                    "\[IndentingNewLine]", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"!", 
                    RowBox[{"StringFreeQ", "[", 
                    RowBox[{
                    RowBox[{"baza", "[", 
                    RowBox[{"[", 
                    RowBox[{"j", ",", "2"}], "]"}], "]"}], ",", 
                    "\"\<NeuAc\>\""}], "]"}]}], "&&", 
                    RowBox[{"!", 
                    RowBox[{"StringFreeQ", "[", 
                    RowBox[{
                    RowBox[{"bazaOAc", "[", 
                    RowBox[{"[", 
                    RowBox[{"w", ",", "2"}], "]"}], "]"}], ",", 
                    "\"\<*NeuAc\>\""}], "]"}]}]}], ",", 
                    RowBox[{"Continue", "[", "]"}]}], "]"}], ";", 
                    "\[IndentingNewLine]", "\[IndentingNewLine]", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"!", 
                    RowBox[{"StringFreeQ", "[", 
                    RowBox[{
                    RowBox[{"baza", "[", 
                    RowBox[{"[", 
                    RowBox[{"j", ",", "2"}], "]"}], "]"}], ",", 
                    "\"\<KDNKDN\>\""}], "]"}]}], "&&", 
                    RowBox[{"!", 
                    RowBox[{"StringFreeQ", "[", 
                    RowBox[{
                    RowBox[{"bazaOAc", "[", 
                    RowBox[{"[", 
                    RowBox[{"w", ",", "2"}], "]"}], "]"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"\"\<NeuAc\>\"", ",", "\"\<NeuGc\>\""}], "}"}]}], 
                    "]"}]}]}], ",", 
                    RowBox[{"Continue", "[", "]"}]}], "]"}], ";", 
                    "\[IndentingNewLine]", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"!", 
                    RowBox[{"StringFreeQ", "[", 
                    RowBox[{
                    RowBox[{"baza", "[", 
                    RowBox[{"[", 
                    RowBox[{"j", ",", "2"}], "]"}], "]"}], ",", 
                    "\"\<NeuGcNeuGc\>\""}], "]"}]}], "&&", 
                    RowBox[{"!", 
                    RowBox[{"StringFreeQ", "[", 
                    RowBox[{
                    RowBox[{"bazaOAc", "[", 
                    RowBox[{"[", 
                    RowBox[{"w", ",", "2"}], "]"}], "]"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"\"\<NeuAc\>\"", ",", "\"\<KDN\>\""}], "}"}]}], 
                    "]"}]}]}], ",", 
                    RowBox[{"Continue", "[", "]"}]}], "]"}], ";", 
                    "\[IndentingNewLine]", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"!", 
                    RowBox[{"StringFreeQ", "[", 
                    RowBox[{
                    RowBox[{"baza", "[", 
                    RowBox[{"[", 
                    RowBox[{"j", ",", "2"}], "]"}], "]"}], ",", 
                    "\"\<NeuAcNeuGc\>\""}], "]"}]}], "&&", 
                    RowBox[{"!", 
                    RowBox[{"StringFreeQ", "[", 
                    RowBox[{
                    RowBox[{"bazaOAc", "[", 
                    RowBox[{"[", 
                    RowBox[{"w", ",", "2"}], "]"}], "]"}], ",", 
                    RowBox[{"{", 
                    RowBox[{
                    "\"\<NeuGc_NeuGc\>\"", ",", "\"\<KDN\>\"", ",", 
                    "\"\<*NeuAc\>\""}], "}"}]}], "]"}]}]}], ",", 
                    RowBox[{"Continue", "[", "]"}]}], "]"}], ";", 
                    "\[IndentingNewLine]", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"!", 
                    RowBox[{"StringFreeQ", "[", 
                    RowBox[{
                    RowBox[{"baza", "[", 
                    RowBox[{"[", 
                    RowBox[{"j", ",", "2"}], "]"}], "]"}], ",", 
                    "\"\<NeuAcKDN\>\""}], "]"}]}], "&&", 
                    RowBox[{"!", 
                    RowBox[{"StringFreeQ", "[", 
                    RowBox[{
                    RowBox[{"bazaOAc", "[", 
                    RowBox[{"[", 
                    RowBox[{"w", ",", "2"}], "]"}], "]"}], ",", 
                    RowBox[{"{", 
                    RowBox[{
                    "\"\<KDN_KDN\>\"", ",", "\"\<NeuGc\>\"", ",", 
                    "\"\<*NeuAc\>\""}], "}"}]}], "]"}]}]}], ",", 
                    RowBox[{"Continue", "[", "]"}]}], "]"}], ";", 
                    "\[IndentingNewLine]", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"!", 
                    RowBox[{"StringFreeQ", "[", 
                    RowBox[{
                    RowBox[{"baza", "[", 
                    RowBox[{"[", 
                    RowBox[{"j", ",", "2"}], "]"}], "]"}], ",", 
                    "\"\<NeuGcKDN\>\""}], "]"}]}], "&&", 
                    RowBox[{"!", 
                    RowBox[{"StringFreeQ", "[", 
                    RowBox[{
                    RowBox[{"bazaOAc", "[", 
                    RowBox[{"[", 
                    RowBox[{"w", ",", "2"}], "]"}], "]"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"\"\<KDN_KDN\>\"", ",", "\"\<NeuAc\>\"", ",", 
                    "\"\<NeuGc_NeuGc\>\""}], "}"}]}], "]"}]}]}], ",", 
                    RowBox[{"Continue", "[", "]"}]}], "]"}], ";", 
                    "\[IndentingNewLine]", "\[IndentingNewLine]", 
                    RowBox[{"a", "=", 
                    RowBox[{"Append", "[", 
                    RowBox[{"a", ",", 
                    RowBox[{
                    RowBox[{"dataD0", "[", 
                    RowBox[{"[", 
                    RowBox[{"i", ",", "z"}], "]"}], "]"}], "-", 
                    RowBox[{"bazaOAc", "[", 
                    RowBox[{"[", 
                    RowBox[{"w", ",", 
                    RowBox[{"-", "1"}]}], "]"}], "]"}]}]}], "]"}]}]}]}], 
                    "]"}], ",", "\[IndentingNewLine]", 
                    RowBox[{"{", 
                    RowBox[{"w", ",", "1", ",", 
                    RowBox[{"Length", "[", "bazaOAc", "]"}]}], "}"}]}], "]"}],
                    ";", "\[IndentingNewLine]", "\[IndentingNewLine]", 
                   RowBox[{"Do", "[", " ", 
                    RowBox[{
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{"dataD0", "[", 
                    RowBox[{"[", 
                    RowBox[{"i", ",", "z"}], "]"}], "]"}], "-", "ToleMSMS"}], 
                    "\[LessEqual]", 
                    RowBox[{"bazadNA", "[", 
                    RowBox[{"[", 
                    RowBox[{"w", ",", "1"}], "]"}], "]"}], "\[LessEqual]", 
                    RowBox[{
                    RowBox[{"dataD0", "[", 
                    RowBox[{"[", 
                    RowBox[{"i", ",", "z"}], "]"}], "]"}], "+", 
                    "ToleMSMS"}]}], "&&", 
                    RowBox[{"!", 
                    RowBox[{"StringFreeQ", "[", 
                    RowBox[{
                    RowBox[{"baza", "[", 
                    RowBox[{"[", 
                    RowBox[{"j", ",", "2"}], "]"}], "]"}], ",", 
                    "\"\<de-N-Ac\>\""}], "]"}]}], "&&", 
                    RowBox[{"StringFreeQ", "[", 
                    RowBox[{
                    RowBox[{"baza", "[", 
                    RowBox[{"[", 
                    RowBox[{"j", ",", "2"}], "]"}], "]"}], ",", 
                    "\"\<KDN\>\""}], "]"}], "&&", 
                    RowBox[{"StringFreeQ", "[", 
                    RowBox[{
                    RowBox[{"baza", "[", 
                    RowBox[{"[", 
                    RowBox[{"j", ",", "2"}], "]"}], "]"}], ",", 
                    "\"\<NeuGc\>\""}], "]"}]}], ",", " ", 
                    "\[IndentingNewLine]", 
                    RowBox[{"a", "=", 
                    RowBox[{"Append", "[", 
                    RowBox[{"a", ",", 
                    RowBox[{
                    RowBox[{"dataD0", "[", 
                    RowBox[{"[", 
                    RowBox[{"i", ",", "z"}], "]"}], "]"}], "-", 
                    RowBox[{"bazadNA", "[", 
                    RowBox[{"[", 
                    RowBox[{"w", ",", 
                    RowBox[{"-", "1"}]}], "]"}], "]"}]}]}], "]"}]}]}], "]"}], 
                    ",", "\[IndentingNewLine]", 
                    RowBox[{"{", 
                    RowBox[{"w", ",", "1", ",", 
                    RowBox[{"Length", "[", "bazadNA", "]"}]}], "}"}]}], "]"}],
                    ";"}]}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
                 "]"}], ";"}], "\[IndentingNewLine]", ",", 
               RowBox[{"{", 
                RowBox[{"z", ",", "2", ",", 
                 RowBox[{"Length", "[", 
                  RowBox[{"dataD0", "[", 
                   RowBox[{"[", "i", "]"}], "]"}], "]"}]}], "}"}]}], "]"}], 
             ";", "\[IndentingNewLine]", "\[IndentingNewLine]", 
             RowBox[{"a", "=", 
              RowBox[{"DeleteDuplicates", "[", "a", "]"}]}], ";", 
             "\[IndentingNewLine]", 
             RowBox[{"b", "=", 
              RowBox[{"DeleteDuplicates", "[", "b", "]"}]}], ";", 
             "\[IndentingNewLine]", 
             RowBox[{"c", "=", 
              RowBox[{"DeleteDuplicates", "[", "c", "]"}]}], ";", 
             "\[IndentingNewLine]", 
             RowBox[{"d", "=", 
              RowBox[{"DeleteDuplicates", "[", "d", "]"}]}], ";", 
             "\[IndentingNewLine]", 
             RowBox[{"e", "=", 
              RowBox[{"DeleteDuplicates", "[", "e", "]"}]}], ";", 
             "\[IndentingNewLine]", "\[IndentingNewLine]", 
             RowBox[{"dataD1", "=", 
              RowBox[{"Append", "[", 
               RowBox[{
               "dataD1", ",", "\[IndentingNewLine]", "\[IndentingNewLine]", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"Length", "[", "a", "]"}], "+", 
                    RowBox[{"Length", "[", "d", "]"}], "+", 
                    RowBox[{"Length", "[", "c", "]"}], "+", 
                    RowBox[{"Length", "[", "e", "]"}]}], ")"}], ",", 
                  RowBox[{"Length", "[", "a", "]"}], ",", 
                  RowBox[{"Length", "[", "d", "]"}], ",", 
                  RowBox[{"Length", "[", "c", "]"}], ",", 
                  RowBox[{"Length", "[", "e", "]"}], ",", 
                  RowBox[{"dataD0", "[", 
                   RowBox[{"[", 
                    RowBox[{"i", ",", "1"}], "]"}], "]"}], ",", 
                  RowBox[{"baza", "[", 
                   RowBox[{"[", 
                    RowBox[{"j", ",", "1"}], "]"}], "]"}], ",", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"dataD0", "[", 
                    RowBox[{"[", 
                    RowBox[{"i", ",", "1"}], "]"}], "]"}], "-", 
                    RowBox[{"baza", "[", 
                    RowBox[{"[", 
                    RowBox[{"j", ",", "1"}], "]"}], "]"}]}], ")"}], ",", 
                  RowBox[{"Drop", "[", 
                   RowBox[{
                    RowBox[{"baza", "[", 
                    RowBox[{"[", "j", "]"}], "]"}], ",", "1"}], "]"}], ",", 
                  "\"\<//\>\"", ",", "a", ",", "d", ",", "c", ",", "e"}], 
                 "}"}]}], "]"}]}]}]}], "]"}], ",", "\[IndentingNewLine]", 
          "\[IndentingNewLine]", "\[IndentingNewLine]", 
          RowBox[{"{", 
           RowBox[{"j", ",", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"LengthWhile", "[", 
               RowBox[{"baza", ",", 
                RowBox[{
                 RowBox[{
                  RowBox[{"#", "[", 
                   RowBox[{"[", "1", "]"}], "]"}], "<", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"dataD0", "[", 
                    RowBox[{"[", 
                    RowBox[{"i", ",", "1"}], "]"}], "]"}], "-", "1"}], 
                   ")"}]}], "&"}]}], "]"}], "+", "1"}], ")"}], ",", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"LengthWhile", "[", 
               RowBox[{"baza", ",", 
                RowBox[{
                 RowBox[{
                  RowBox[{"#", "[", 
                   RowBox[{"[", "1", "]"}], "]"}], "<", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"dataD0", "[", 
                    RowBox[{"[", 
                    RowBox[{"i", ",", "1"}], "]"}], "]"}], "+", "1"}], 
                   ")"}]}], "&"}]}], "]"}], "+", "1"}], ")"}]}], "}"}]}], 
         "]"}], ";", "\[IndentingNewLine]", "\[IndentingNewLine]", 
        RowBox[{"progress", "=", "i"}], ";"}], ",", "\[IndentingNewLine]", 
       RowBox[{"{", 
        RowBox[{"i", ",", "1", ",", 
         RowBox[{"Length", "[", "dataD0", "]"}]}], "}"}]}], "]"}], ";", 
     "\[IndentingNewLine]", "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{"Clear", "[", "a", "]"}], ";", 
     RowBox[{"a", "=", 
      RowBox[{"{", "}"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"Do", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"dataD1", "[", 
            RowBox[{"[", 
             RowBox[{"i", ",", "1"}], "]"}], "]"}], "\[Equal]", "0"}], ",", 
          RowBox[{"a", "=", 
           RowBox[{"Append", "[", 
            RowBox[{"a", ",", 
             RowBox[{"{", "i", "}"}]}], "]"}]}]}], "]"}], ";"}], 
       "\[IndentingNewLine]", ",", 
       RowBox[{"{", 
        RowBox[{"i", ",", "1", ",", 
         RowBox[{"Length", "[", "dataD1", "]"}]}], "}"}]}], "]"}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"dataD1", "=", 
      RowBox[{"Delete", "[", 
       RowBox[{"dataD1", ",", "a"}], "]"}]}], ";", "\[IndentingNewLine]", 
     "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{"CreateDialog", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"TextCell", "[", "\"\<Search completed\>\"", "]"}], ",", 
        RowBox[{"DefaultButton", "[", "]"}]}], "}"}], "]"}], ";"}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{"Method", "\[Rule]", "\"\<Queued\>\""}]}], "\[IndentingNewLine]", 
   "]"}], "\[IndentingNewLine]"}]], "Input",
 Editable->False,
 CellOpen->False],

Cell[BoxData[
 ButtonBox["\<\"Search\"\>",
  Appearance->Automatic,
  ButtonFunction:>(
   Clear[$CellContext`dataD1]; $CellContext`dataD1 = {}; $CellContext`baza = 
    Select[$CellContext`baza0, And[
       StringFreeQ[
        Part[#, 2], $CellContext`exclude], 
       StringFreeQ[
        Part[#, 3], $CellContext`exclude1]]& ]; $CellContext`progress = 
    0; $CellContext`duzina = Length[$CellContext`dataD0]; Do[Do[
       If[
       Part[$CellContext`dataD0, $CellContext`i, 1] - $CellContext`Tole <= 
        Part[$CellContext`baza, $CellContext`j, 1] <= 
        Part[$CellContext`dataD0, $CellContext`i, 1] + $CellContext`Tole, 
        Clear[$CellContext`a, $CellContext`b, $CellContext`c, $CellContext`d, \
$CellContext`e, $CellContext`baza1]; $CellContext`a = {}; $CellContext`b = {}; \
$CellContext`c = {}; $CellContext`d = {}; $CellContext`e = {}; \
$CellContext`baza1 = 
         Select[$CellContext`baza0, Part[#, -1] == 
           Part[$CellContext`baza, $CellContext`j, -1]& ]; Do[Do[
            If[
             Or[
             Part[$CellContext`dataD0, $CellContext`i, $CellContext`z] - \
$CellContext`ToleMSMS <= Part[$CellContext`baza1, $CellContext`w, 1] <= 
              Part[$CellContext`dataD0, $CellContext`i, $CellContext`z] + \
$CellContext`ToleMSMS, 
              Part[$CellContext`dataD0, $CellContext`i, $CellContext`z] - \
$CellContext`ToleMSMS <= 
              Part[$CellContext`baza1, $CellContext`w, 1] - 18.0152 <= 
              Part[$CellContext`dataD0, $CellContext`i, $CellContext`z] + \
$CellContext`ToleMSMS], If[
               Not[
                StringFreeQ[
                 Part[$CellContext`baza1, $CellContext`w, 2], "Gb4"]], 
               Continue[]]; If[
               And[
                Not[
                 StringFreeQ[
                  Part[$CellContext`baza, $CellContext`j, 2], {"LM", "LD"}]], 
                Not[
                 StringFreeQ[
                  Part[$CellContext`baza1, $CellContext`w, 2], {
                  "KDN", "NeuGc", "OAc", "de-N-Ac"}]]], 
               Continue[]]; If[
               And[
                StringFreeQ[
                 Part[$CellContext`baza, $CellContext`j, 2], "lactone"], 
                Not[
                 StringFreeQ[
                  Part[$CellContext`baza1, $CellContext`w, 2], "lactone"]]], 
               Continue[]]; If[
               Not[
                StringFreeQ[
                 Part[$CellContext`baza1, $CellContext`w, 2], "GM4"]], 
               Continue[]]; If[
               And[
                StringFreeQ[
                 Part[$CellContext`baza, $CellContext`j, 2], "KDN"], 
                Not[
                 StringFreeQ[
                  Part[$CellContext`baza1, $CellContext`w, 2], "KDN"]]], 
               Continue[]]; If[
               And[
                StringFreeQ[
                 Part[$CellContext`baza, $CellContext`j, 2], "NeuGc"], 
                Not[
                 StringFreeQ[
                  Part[$CellContext`baza1, $CellContext`w, 2], "NeuGc"]]], 
               Continue[]]; If[
               And[
                StringFreeQ[
                 Part[$CellContext`baza, $CellContext`j, 2], "sulfo"], 
                Not[
                 StringFreeQ[
                  Part[$CellContext`baza1, $CellContext`w, 2], "sulfo"]]], 
               Continue[]]; If[
               And[
                StringFreeQ[
                 Part[$CellContext`baza, $CellContext`j, 2], "Fuc"], 
                Not[
                 StringFreeQ[
                  Part[$CellContext`baza1, $CellContext`w, 2], "Fuc"]]], 
               Continue[]]; If[
               And[
                StringFreeQ[
                 Part[$CellContext`baza, $CellContext`j, 2], "GlcA"], 
                Not[
                 StringFreeQ[
                  Part[$CellContext`baza1, $CellContext`w, 2], "GlcA"]]], 
               Continue[]]; If[
               And[
                StringFreeQ[
                 Part[$CellContext`baza, $CellContext`j, 2], "OAc"], 
                Not[
                 StringFreeQ[
                  Part[$CellContext`baza1, $CellContext`w, 2], "OAc"]]], 
               Continue[]]; If[
               And[
                Not[
                 StringFreeQ[
                  Part[$CellContext`baza, $CellContext`j, 2], "OAc"]], 
                StringFreeQ[
                 Part[$CellContext`baza, $CellContext`j, 2], "2*OAc"], 
                Not[
                 StringFreeQ[
                  Part[$CellContext`baza1, $CellContext`w, 2], "2*OAc"]]], 
               Continue[]]; If[
               And[
                StringFreeQ[
                 Part[$CellContext`baza, $CellContext`j, 2], "Hex"], 
                Not[
                 StringFreeQ[
                  Part[$CellContext`baza1, $CellContext`w, 2], "Hex"]]], 
               If[
                StringFreeQ[
                 Part[$CellContext`baza1, $CellContext`w, 2], "HexCer"], 
                Continue[]]]; If[
               And[
                StringFreeQ[
                 Part[$CellContext`baza, $CellContext`j, 2], "HexNAc"], 
                Not[
                 StringFreeQ[
                  Part[$CellContext`baza1, $CellContext`w, 2], "HexNAc"]]], 
               Continue[]]; If[
               And[
                Not[
                 StringFreeQ[
                  Part[$CellContext`baza, $CellContext`j, 2], "HexNAc"]], 
                Not[
                 StringFreeQ[
                  Part[$CellContext`baza1, $CellContext`w, 2], "Hex G"]]], 
               Continue[]]; If[
               And[
                StringFreeQ[
                 Part[$CellContext`baza, $CellContext`j, 2], "de-N-Ac"], 
                Not[
                 StringFreeQ[
                  Part[$CellContext`baza1, $CellContext`w, 2], "de-N-Ac"]]], 
               Continue[]]; If[
               And[
                Not[
                 StringFreeQ[
                  Part[$CellContext`baza, $CellContext`j, 2], {
                  "GM1(", "GM2(", "GM3("}]], 
                StringFreeQ[
                 Part[$CellContext`baza1, $CellContext`w, 2], {
                  StringExpression["GM", 
                   Blank[], "("], "Gg", "HexCer", "LacCer"}]], 
               Continue[]]; If[
               And[
                Not[
                 StringFreeQ[
                  Part[$CellContext`baza, $CellContext`j, 2], {
                  "GD1(", "GD2(", "GD3("}]], 
                StringFreeQ[
                 Part[$CellContext`baza1, $CellContext`w, 2], {
                  StringExpression["GD", 
                   Blank[], "("], 
                  StringExpression["GM", 
                   Blank[], "("], "Gg", "HexCer", "LacCer"}]], 
               If[
                And[
                 Not[
                  StringFreeQ[
                   Part[$CellContext`baza, $CellContext`j, 2], "NeuAc"]], 
                 Not[
                  StringFreeQ[
                   Part[$CellContext`baza1, $CellContext`w, 2], "GM"]]], Null, 
                Continue[]]]; If[
               And[
                Not[
                 StringFreeQ[
                  Part[$CellContext`baza, $CellContext`j, 2], "KDNKDN"]], 
                Not[
                 StringFreeQ[
                  Part[$CellContext`baza1, $CellContext`w, 2], {
                  "NeuAc", "NeuGc"}]]], 
               Continue[]]; If[
               And[
                Not[
                 StringFreeQ[
                  Part[$CellContext`baza, $CellContext`j, 2], "NeuGcNeuGc"]], 
                Not[
                 StringFreeQ[
                  Part[$CellContext`baza1, $CellContext`w, 2], {
                  "NeuAc", "KDN"}]]], 
               Continue[]]; If[
               And[
                Not[
                 StringFreeQ[
                  Part[$CellContext`baza, $CellContext`j, 2], "NeuAcNeuGc"]], 
                Not[
                 StringFreeQ[
                  Part[$CellContext`baza1, $CellContext`w, 2], {
                  "NeuGcNeuGc", "NeuGcKDN"}]]], 
               Continue[]]; If[
               And[
                Not[
                 StringFreeQ[
                  Part[$CellContext`baza, $CellContext`j, 2], "NeuAcKDN"]], 
                Not[
                 StringFreeQ[
                  Part[$CellContext`baza1, $CellContext`w, 2], {
                  "KDNKDN", "NeuGcKDN"}]]], 
               Continue[]]; If[
               And[
                Not[
                 StringFreeQ[
                  Part[$CellContext`baza, $CellContext`j, 2], "NeuGcKDN"]], 
                Not[
                 StringFreeQ[
                  Part[$CellContext`baza1, $CellContext`w, 2], {
                  "KDNKDN", "NeuAcKDN", "NeuGcNeuGc", "NeuAcNeuGc"}]]], 
               Continue[]]; If[
               And[
                Not[
                 StringFreeQ[
                  Part[$CellContext`baza, $CellContext`j, 2], "GP"]], 
                Not[
                 StringFreeQ[
                  Part[$CellContext`baza1, $CellContext`w, 2], "GH"]]], 
               Continue[]]; If[
               And[
                Not[
                 StringFreeQ[
                  Part[$CellContext`baza, $CellContext`j, 2], "GQ"]], 
                Not[
                 StringFreeQ[
                  Part[$CellContext`baza1, $CellContext`w, 2], {
                  "GH", "GP"}]]], 
               Continue[]]; If[
               And[
                Not[
                 StringFreeQ[
                  Part[$CellContext`baza, $CellContext`j, 2], "GT"]], 
                Not[
                 StringFreeQ[
                  Part[$CellContext`baza1, $CellContext`w, 2], {
                  "GH", "GP", "GQ"}]]], 
               Continue[]]; If[
               And[
                Not[
                 StringFreeQ[
                  Part[$CellContext`baza, $CellContext`j, 2], "GD"]], 
                Not[
                 StringFreeQ[
                  Part[$CellContext`baza1, $CellContext`w, 2], {
                  "GT", "GH", "GP", "GQ"}]]], 
               Continue[]]; If[
               And[
                Not[
                 StringFreeQ[
                  Part[$CellContext`baza, $CellContext`j, 2], "GM"]], 
                Not[
                 StringFreeQ[
                  Part[$CellContext`baza1, $CellContext`w, 2], {
                  "GT", "GH", "GP", "GQ", "GD"}]]], 
               Continue[]]; If[
               And[
                Not[
                 StringFreeQ[
                  Part[$CellContext`baza, $CellContext`j, 2], "Gg"]], 
                Not[
                 StringFreeQ[
                  Part[$CellContext`baza1, $CellContext`w, 2], {
                  "GT", "GH", "GP", "GQ", "GD", "GM"}]]], 
               Continue[]]; If[
               And[
                Not[
                 StringFreeQ[
                  Part[$CellContext`baza, $CellContext`j, 2], {
                  "GM3", "GD3", "GT3", "GQ3"}]], 
                Not[
                 StringFreeQ[
                  Part[$CellContext`baza1, $CellContext`w, 2], "Gg"]]], 
               Continue[]]; 
             If[Part[$CellContext`dataD0, $CellContext`i, $CellContext`z] - \
$CellContext`ToleMSMS <= Part[$CellContext`baza1, $CellContext`w, 1] <= 
               Part[$CellContext`dataD0, $CellContext`i, $CellContext`z] + \
$CellContext`ToleMSMS, $CellContext`c = 
                Append[$CellContext`c, 
                  Part[$CellContext`dataD0, $CellContext`i, $CellContext`z] - 
                  Part[$CellContext`baza1, $CellContext`w, 2]]; 
               Break[], $CellContext`e = 
               Append[$CellContext`e, 
                 Part[$CellContext`dataD0, $CellContext`i, $CellContext`z] - 
                 Part[$CellContext`baza1, $CellContext`w, 2]]]; 
             Null], {$CellContext`w, 
             LengthWhile[$CellContext`baza1, Part[#, 1] < 
               Part[$CellContext`dataD0, $CellContext`i, $CellContext`z] - 
                1& ] + 1, 
             LengthWhile[$CellContext`baza1, Part[#, 1] < 
               Part[$CellContext`dataD0, $CellContext`i, $CellContext`z] + 
                19& ] + 1}]; Do[
            If[
            Part[$CellContext`dataD0, $CellContext`i, $CellContext`z] - \
$CellContext`ToleMSMS <= Part[$CellContext`cer, $CellContext`w, 1] <= 
             Part[$CellContext`dataD0, $CellContext`i, $CellContext`z] + \
$CellContext`ToleMSMS, 
             If[
             Part[$CellContext`cer, $CellContext`w, -1] == 
              Part[$CellContext`baza, $CellContext`j, -1], $CellContext`c = 
              Append[$CellContext`c, 
                Part[$CellContext`dataD0, $CellContext`i, $CellContext`z] - 
                Part[$CellContext`cer, $CellContext`w, -1]]]], \
{$CellContext`w, 1, 
             Length[$CellContext`cer]}]; If[
            Not[
             StringFreeQ[
              Part[$CellContext`baza, $CellContext`j, 2], {
              "GM4", "Gg", "LacCer", "HexCer"}]], Null, Do[
              If[
              Part[$CellContext`dataD0, $CellContext`i, $CellContext`z] - \
$CellContext`ToleMSMS <= Part[$CellContext`bazaSA, $CellContext`w, 1] <= 
               Part[$CellContext`dataD0, $CellContext`i, $CellContext`z] + \
$CellContext`ToleMSMS, If[
                 And[
                  Not[
                   StringFreeQ[
                    Part[$CellContext`baza, $CellContext`j, 2], {
                    "GM1(", "GM2(", "GM3("}]], 
                  Not[
                   StringFreeQ[
                    Part[$CellContext`bazaSA, $CellContext`w, 2], "NeuAc"]]], 
                 Continue[]]; If[
                 And[
                  Not[
                   StringFreeQ[
                    Part[$CellContext`baza, $CellContext`j, 2], "LD"]], 
                  Not[
                   StringFreeQ[
                    Part[$CellContext`bazaSA, $CellContext`w, 2], {
                    "NeuGc", "KDN"}]]], 
                 Continue[]]; If[
                 And[
                  Not[
                   StringFreeQ[
                    Part[$CellContext`baza, $CellContext`j, 2], "GM"]], 
                  Not[
                   StringFreeQ[
                    Part[$CellContext`bazaSA, $CellContext`w, 2], "*"]]], 
                 Continue[]]; If[
                 And[
                  StringFreeQ[
                   Part[$CellContext`baza, $CellContext`j, 2], "KDN"], 
                  Not[
                   StringFreeQ[
                    Part[$CellContext`bazaSA, $CellContext`w, 2], "KDN"]]], 
                 Continue[]]; If[
                 And[
                  StringFreeQ[
                   Part[$CellContext`baza, $CellContext`j, 2], "NeuGc"], 
                  Not[
                   StringFreeQ[
                    Part[$CellContext`bazaSA, $CellContext`w, 2], "NeuGc"]]], 
                 Continue[]]; If[
                 And[
                  Not[
                   StringFreeQ[
                    Part[$CellContext`baza, $CellContext`j, 2], "NeuAc"]], 
                  Not[
                   StringFreeQ[
                    Part[$CellContext`bazaSA, $CellContext`w, 2], "*NeuAc"]]], 
                 Continue[]]; If[
                 And[
                  Not[
                   StringFreeQ[
                    Part[$CellContext`baza, $CellContext`j, 2], "KDNKDN"]], 
                  Not[
                   StringFreeQ[
                    Part[$CellContext`bazaSA, $CellContext`w, 2], {
                    "NeuAc", "NeuGc"}]]], 
                 Continue[]]; If[
                 And[
                  Not[
                   StringFreeQ[
                    Part[$CellContext`baza, $CellContext`j, 2], 
                    "NeuGcNeuGc"]], 
                  Not[
                   StringFreeQ[
                    Part[$CellContext`bazaSA, $CellContext`w, 2], {
                    "NeuAc", "KDN"}]]], 
                 Continue[]]; If[
                 And[
                  Not[
                   StringFreeQ[
                    Part[$CellContext`baza, $CellContext`j, 2], 
                    "NeuAcNeuGc"]], 
                  Not[
                   StringFreeQ[
                    Part[$CellContext`bazaSA, $CellContext`w, 2], {
                    "NeuGc_NeuGc", "KDN", "*NeuAc"}]]], 
                 Continue[]]; If[
                 And[
                  Not[
                   StringFreeQ[
                    Part[$CellContext`baza, $CellContext`j, 2], "NeuAcKDN"]], 
                  Not[
                   StringFreeQ[
                    Part[$CellContext`bazaSA, $CellContext`w, 2], {
                    "KDN_KDN", "NeuGc", "*NeuAc"}]]], 
                 Continue[]]; If[
                 And[
                  Not[
                   StringFreeQ[
                    Part[$CellContext`baza, $CellContext`j, 2], "NeuGcKDN"]], 
                  Not[
                   StringFreeQ[
                    Part[$CellContext`bazaSA, $CellContext`w, 2], {
                    "KDN_KDN", "NeuAc", "NeuGc_NeuGc"}]]], 
                 Continue[]]; $CellContext`d = 
                Append[$CellContext`d, 
                  Part[$CellContext`dataD0, $CellContext`i, $CellContext`z] - 
                  Part[$CellContext`bazaSA, $CellContext`w, -1]]], \
{$CellContext`w, 1, 
               Length[$CellContext`bazaSA]}]; Do[
              If[
               And[
               Part[$CellContext`dataD0, $CellContext`i, $CellContext`z] - \
$CellContext`ToleMSMS <= Part[$CellContext`bazaOAc, $CellContext`w, 1] <= 
                Part[$CellContext`dataD0, $CellContext`i, $CellContext`z] + \
$CellContext`ToleMSMS, 
                Not[
                 StringFreeQ[
                  Part[$CellContext`baza, $CellContext`j, 2], "OAc"]]], If[
                 Not[
                  StringFreeQ[
                   Part[$CellContext`baza, $CellContext`j, 2], "LD"]], 
                 Continue[]]; If[
                 And[
                  Not[
                   StringFreeQ[
                    Part[$CellContext`baza, $CellContext`j, 2], {
                    "GM1(", "GM2(", "GM3("}]], 
                  Not[
                   StringFreeQ[
                    Part[$CellContext`bazaOAc, $CellContext`w, 2], "NeuAc"]]], 
                 Continue[]]; If[
                 And[
                  Not[
                   StringFreeQ[
                    Part[$CellContext`baza, $CellContext`j, 2], "GM"]], 
                  Not[
                   StringFreeQ[
                    Part[$CellContext`bazaOAc, $CellContext`w, 2], {
                    "*NeuAc", "("}]]], 
                 Continue[]]; If[
                 And[
                  StringFreeQ[
                   Part[$CellContext`baza, $CellContext`j, 2], "KDN"], 
                  Not[
                   StringFreeQ[
                    Part[$CellContext`bazaOAc, $CellContext`w, 2], "KDN"]]], 
                 Continue[]]; If[
                 And[
                  StringFreeQ[
                   Part[$CellContext`baza, $CellContext`j, 2], "NeuGc"], 
                  Not[
                   StringFreeQ[
                    Part[$CellContext`bazaOAc, $CellContext`w, 2], "NeuGc"]]], 
                 Continue[]]; If[
                 And[
                  Not[
                   StringFreeQ[
                    Part[$CellContext`baza, $CellContext`j, 2], "NeuAc"]], 
                  Not[
                   StringFreeQ[
                    Part[$CellContext`bazaOAc, $CellContext`w, 2], 
                    "*NeuAc"]]], 
                 Continue[]]; If[
                 And[
                  Not[
                   StringFreeQ[
                    Part[$CellContext`baza, $CellContext`j, 2], "KDNKDN"]], 
                  Not[
                   StringFreeQ[
                    Part[$CellContext`bazaOAc, $CellContext`w, 2], {
                    "NeuAc", "NeuGc"}]]], 
                 Continue[]]; If[
                 And[
                  Not[
                   StringFreeQ[
                    Part[$CellContext`baza, $CellContext`j, 2], 
                    "NeuGcNeuGc"]], 
                  Not[
                   StringFreeQ[
                    Part[$CellContext`bazaOAc, $CellContext`w, 2], {
                    "NeuAc", "KDN"}]]], 
                 Continue[]]; If[
                 And[
                  Not[
                   StringFreeQ[
                    Part[$CellContext`baza, $CellContext`j, 2], 
                    "NeuAcNeuGc"]], 
                  Not[
                   StringFreeQ[
                    Part[$CellContext`bazaOAc, $CellContext`w, 2], {
                    "NeuGc_NeuGc", "KDN", "*NeuAc"}]]], 
                 Continue[]]; If[
                 And[
                  Not[
                   StringFreeQ[
                    Part[$CellContext`baza, $CellContext`j, 2], "NeuAcKDN"]], 
                  Not[
                   StringFreeQ[
                    Part[$CellContext`bazaOAc, $CellContext`w, 2], {
                    "KDN_KDN", "NeuGc", "*NeuAc"}]]], 
                 Continue[]]; If[
                 And[
                  Not[
                   StringFreeQ[
                    Part[$CellContext`baza, $CellContext`j, 2], "NeuGcKDN"]], 
                  Not[
                   StringFreeQ[
                    Part[$CellContext`bazaOAc, $CellContext`w, 2], {
                    "KDN_KDN", "NeuAc", "NeuGc_NeuGc"}]]], 
                 Continue[]]; $CellContext`a = 
                Append[$CellContext`a, 
                  Part[$CellContext`dataD0, $CellContext`i, $CellContext`z] - 
                  Part[$CellContext`bazaOAc, $CellContext`w, -1]]], \
{$CellContext`w, 1, 
               Length[$CellContext`bazaOAc]}]; Do[
              If[
               And[
               Part[$CellContext`dataD0, $CellContext`i, $CellContext`z] - \
$CellContext`ToleMSMS <= Part[$CellContext`bazadNA, $CellContext`w, 1] <= 
                Part[$CellContext`dataD0, $CellContext`i, $CellContext`z] + \
$CellContext`ToleMSMS, 
                Not[
                 StringFreeQ[
                  Part[$CellContext`baza, $CellContext`j, 2], "de-N-Ac"]], 
                StringFreeQ[
                 Part[$CellContext`baza, $CellContext`j, 2], "KDN"], 
                StringFreeQ[
                 Part[$CellContext`baza, $CellContext`j, 2], 
                 "NeuGc"]], $CellContext`a = 
               Append[$CellContext`a, 
                 Part[$CellContext`dataD0, $CellContext`i, $CellContext`z] - 
                 Part[$CellContext`bazadNA, $CellContext`w, -1]]], \
{$CellContext`w, 1, 
               Length[$CellContext`bazadNA]}]; Null]; 
          Null, {$CellContext`z, 2, 
           Length[
            Part[$CellContext`dataD0, $CellContext`i]]}]; $CellContext`a = 
         DeleteDuplicates[$CellContext`a]; $CellContext`b = 
         DeleteDuplicates[$CellContext`b]; $CellContext`c = 
         DeleteDuplicates[$CellContext`c]; $CellContext`d = 
         DeleteDuplicates[$CellContext`d]; $CellContext`e = 
         DeleteDuplicates[$CellContext`e]; $CellContext`dataD1 = 
         Append[$CellContext`dataD1, {
           Length[$CellContext`a] + Length[$CellContext`d] + 
            Length[$CellContext`c] + Length[$CellContext`e], 
            Length[$CellContext`a], 
            Length[$CellContext`d], 
            Length[$CellContext`c], 
            Length[$CellContext`e], 
            Part[$CellContext`dataD0, $CellContext`i, 1], 
            Part[$CellContext`baza, $CellContext`j, 1], 
            Part[$CellContext`dataD0, $CellContext`i, 1] - 
            Part[$CellContext`baza, $CellContext`j, 1], 
            Drop[
             Part[$CellContext`baza, $CellContext`j], 1], 
            "//", $CellContext`a, $CellContext`d, $CellContext`c, \
$CellContext`e}]], {$CellContext`j, 
        LengthWhile[$CellContext`baza, Part[#, 1] < 
          Part[$CellContext`dataD0, $CellContext`i, 1] - 1& ] + 1, 
        LengthWhile[$CellContext`baza, Part[#, 1] < 
          Part[$CellContext`dataD0, $CellContext`i, 1] + 1& ] + 
        1}]; $CellContext`progress = $CellContext`i; Null, {$CellContext`i, 1, 
      Length[$CellContext`dataD0]}]; 
   Clear[$CellContext`a]; $CellContext`a = {}; 
   Do[If[Part[$CellContext`dataD1, $CellContext`i, 1] == 0, $CellContext`a = 
       Append[$CellContext`a, {$CellContext`i}]]; Null, {$CellContext`i, 1, 
      Length[$CellContext`dataD1]}]; $CellContext`dataD1 = 
    Delete[$CellContext`dataD1, $CellContext`a]; CreateDialog[{
      TextCell["Search completed"], 
      DefaultButton[]}]; Null),
  Evaluator->Automatic,
  Method->"Queued"]], "Output"]
}, {2}]],

Cell[BoxData[""], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ProgressIndicator", "[", 
  RowBox[{
   RowBox[{"Dynamic", "[", "progress", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", 
     RowBox[{"Dynamic", "[", "duzina", "]"}]}], "}"}]}], "]"}]], "Input",
 Editable->False,
 CellOpen->False],

Cell[BoxData[
 ProgressIndicatorBox[Dynamic[$CellContext`progress], {0, 
   Dynamic[$CellContext`duzina]}]], "Output"]
}, {2}]],

Cell[BoxData[""], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Button", "[", 
  RowBox[{"\"\<Display Results\>\"", ",", 
   RowBox[{
    RowBox[{"CreateDialog", "[", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"TextCell", "[", 
        RowBox[{"Pane", "[", 
         RowBox[{
          RowBox[{"Grid", "[", 
           RowBox[{
            RowBox[{"Prepend", "[", 
             RowBox[{
              RowBox[{"SortBy", "[", 
               RowBox[{"dataD1", ",", 
                RowBox[{
                 RowBox[{"{", 
                  RowBox[{
                   RowBox[{"#", "[", 
                    RowBox[{"[", "6", "]"}], "]"}], ",", 
                   RowBox[{"-", 
                    RowBox[{"#", "[", 
                    RowBox[{"[", "1", "]"}], "]"}]}], ",", 
                   RowBox[{"-", 
                    RowBox[{"#", "[", 
                    RowBox[{"[", "4", "]"}], "]"}]}]}], "}"}], "&"}]}], "]"}],
               ",", 
              RowBox[{"{", 
               RowBox[{"\"\<N\!\(\*
StyleBox[\"total\",
FontSize->10]\)\>\"", ",", "\"\<N\!\(\*
StyleBox[\"(\",
FontSize->10]\)\!\(\*
StyleBox[\"OAc\",
FontSize->10]\)\!\(\*
StyleBox[\" \",
FontSize->10]\)\!\(\*
StyleBox[\"SA\",
FontSize->10]\)\!\(\*
StyleBox[\" \",
FontSize->10]\)\!\(\*
StyleBox[\"&\",
FontSize->10]\)\!\(\*
StyleBox[\" \",
FontSize->10]\)\!\(\*
StyleBox[\"dNAc\",
FontSize->10]\)\!\(\*
StyleBox[\" \",
FontSize->10]\)\!\(\*
StyleBox[\"SA\",
FontSize->10]\)\!\(\*
StyleBox[\")\",
FontSize->10]\)\>\"", ",", "\"\<N\!\(\*
StyleBox[\"(\",
FontSize->10]\)\!\(\*
StyleBox[\"Bx\",
FontSize->10]\)\!\(\*
StyleBox[\"-\",
FontSize->10]\)\!\(\*
StyleBox[\"ions\",
FontSize->10]\)\!\(\*
StyleBox[\")\",
FontSize->10]\)\>\"", ",", "\"\<N\!\(\*
StyleBox[\"(\",
FontSize->10]\)\!\(\*
StyleBox[\"Y\",
FontSize->10]\)\!\(\*
StyleBox[\"-\",
FontSize->10]\)\!\(\*
StyleBox[\"ions\",
FontSize->10]\)\!\(\*
StyleBox[\")\",
FontSize->10]\)\>\"", ",", "\"\<N\!\(\*
StyleBox[\"(\",
FontSize->10]\)\!\(\*
StyleBox[\"Z\",
FontSize->10]\)\!\(\*
StyleBox[\"-\",
FontSize->10]\)\!\(\*
StyleBox[\"ions\",
FontSize->10]\)\!\(\*
StyleBox[\")\",
FontSize->10]\)\>\"", ",", " ", "\"\<Experimental mass\>\"", ",", 
                "\"\<Theoretical mass\>\"", ",", "\"\<\[DifferenceDelta]\>\"",
                 ",", " ", "\"\<GSL\>\"", ",", "\"\<//\>\"", ",", 
                "\"\<OAc SA & dNAc SA\>\"", ",", "\"\<Bx-ions\>\"", " ", ",", 
                "\"\<Y-ions\>\"", ",", "\"\<Z-ions\>\""}], "}"}]}], "]"}], 
            ",", " ", 
            RowBox[{"Alignment", "\[Rule]", "Left"}], ",", 
            RowBox[{"Frame", "\[Rule]", "All"}], ",", 
            RowBox[{"ItemStyle", "\[Rule]", "\"\<Text\>\""}], ",", " ", 
            RowBox[{"Background", "\[Rule]", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"{", "}"}], ",", 
               RowBox[{"{", "LightGray", "}"}]}], "}"}]}]}], "]"}], ",", 
          RowBox[{"ImageSize", "\[Rule]", 
           RowBox[{"{", 
            RowBox[{"1300", ",", "800"}], "}"}]}], ",", 
          RowBox[{"Scrollbars", "\[Rule]", "True"}]}], "]"}], "]"}], ",", 
       RowBox[{"DefaultButton", "[", "]"}]}], "}"}], "]"}], ";"}], ",", 
   RowBox[{"Method", "\[Rule]", "\"\<Queued\>\""}]}], "]"}]], "Input",
 Editable->False,
 CellOpen->False],

Cell[BoxData[
 ButtonBox["\<\"Display Results\"\>",
  Appearance->Automatic,
  ButtonFunction:>(CreateDialog[{
      TextCell[
       Pane[
        Grid[
         Prepend[
          SortBy[$CellContext`dataD1, {
            Part[#, 6], -Part[#, 1], -Part[#, 4]}& ], {
          "N\!\(\*\nStyleBox[\"total\",\nFontSize->10]\)", 
           "N\!\(\*\nStyleBox[\"(\",\nFontSize->10]\)\!\(\*\n\
StyleBox[\"OAc\",\nFontSize->10]\)\!\(\*\nStyleBox[\" \",\n\
FontSize->10]\)\!\(\*\nStyleBox[\"SA\",\nFontSize->10]\)\!\(\*\nStyleBox[\" \
\",\nFontSize->10]\)\!\(\*\nStyleBox[\"&\",\nFontSize->10]\)\!\(\*\nStyleBox[\
\" \",\nFontSize->10]\)\!\(\*\nStyleBox[\"dNAc\",\nFontSize->10]\)\!\(\*\n\
StyleBox[\" \",\nFontSize->10]\)\!\(\*\nStyleBox[\"SA\",\nFontSize->10]\)\!\(\
\*\nStyleBox[\")\",\nFontSize->10]\)", 
           "N\!\(\*\nStyleBox[\"(\",\nFontSize->10]\)\!\(\*\nStyleBox[\"Bx\",\
\nFontSize->10]\)\!\(\*\nStyleBox[\"-\",\nFontSize->10]\)\!\(\*\n\
StyleBox[\"ions\",\nFontSize->10]\)\!\(\*\nStyleBox[\")\",\nFontSize->10]\)", 
           "N\!\(\*\nStyleBox[\"(\",\nFontSize->10]\)\!\(\*\nStyleBox[\"Y\",\n\
FontSize->10]\)\!\(\*\nStyleBox[\"-\",\nFontSize->10]\)\!\(\*\n\
StyleBox[\"ions\",\nFontSize->10]\)\!\(\*\nStyleBox[\")\",\nFontSize->10]\)", 
           "N\!\(\*\nStyleBox[\"(\",\nFontSize->10]\)\!\(\*\nStyleBox[\"Z\",\n\
FontSize->10]\)\!\(\*\nStyleBox[\"-\",\nFontSize->10]\)\!\(\*\n\
StyleBox[\"ions\",\nFontSize->10]\)\!\(\*\nStyleBox[\")\",\nFontSize->10]\)", 
           "Experimental mass", "Theoretical mass", "\[DifferenceDelta]", 
           "GSL", "//", "OAc SA & dNAc SA", "Bx-ions", "Y-ions", "Z-ions"}], 
         Alignment -> Left, Frame -> All, ItemStyle -> "Text", 
         Background -> {{}, {LightGray}}], ImageSize -> {1300, 800}, 
        Scrollbars -> True]], 
      DefaultButton[]}]; Null),
  Evaluator->Automatic,
  Method->"Queued"]], "Output"]
}, {2}]],

Cell[BoxData[""], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Button", "[", 
  RowBox[{"\"\<Save Results\>\"", ",", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"CreateDialog", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"TextCell", "[", "\"\<Enter a name: \>\"", "]"}], ",", 
        RowBox[{"InputField", "[", 
         RowBox[{
          RowBox[{"Dynamic", "[", "name", "]"}], ",", "String"}], "]"}], ",", 
        RowBox[{"TextCell", "[", "\"\<Select a folder: \>\"", "]"}], ",", 
        RowBox[{"FileNameSetter", "[", 
         RowBox[{
          RowBox[{"Dynamic", "[", "folder", "]"}], ",", "\"\<Directory\>\""}],
          "]"}], ",", "\[IndentingNewLine]", 
        RowBox[{"DefaultButton", "[", 
         RowBox[{"DialogReturn", "[", 
          RowBox[{"Export", "[", 
           RowBox[{
            RowBox[{"ToString", "[", 
             RowBox[{"folder", "*", "name", "*", "\"\<.xls\>\""}], "]"}], ",", 
            RowBox[{"Prepend", "[", 
             RowBox[{
              RowBox[{"SortBy", "[", 
               RowBox[{"dataD1", ",", 
                RowBox[{
                 RowBox[{"{", 
                  RowBox[{
                   RowBox[{"#", "[", 
                    RowBox[{"[", "6", "]"}], "]"}], ",", 
                   RowBox[{"-", 
                    RowBox[{"#", "[", 
                    RowBox[{"[", "1", "]"}], "]"}]}], ",", 
                   RowBox[{"-", 
                    RowBox[{"#", "[", 
                    RowBox[{"[", "4", "]"}], "]"}]}]}], "}"}], "&"}]}], "]"}],
               ",", 
              RowBox[{"{", 
               RowBox[{
               "\"\<N-total\>\"", ",", "\"\<N(OAc SA & dNAc SA)\>\"", ",", 
                "\"\<N(Bx-ions)\>\"", ",", "\"\<N(Y-ions)\>\"", ",", 
                "\"\<N(Z-ions)\>\"", ",", " ", "\"\<Experimental mass\>\"", 
                ",", "\"\<Theoretical mass\>\"", ",", "\"\<Delta\>\"", ",", 
                " ", "\"\<GSL\>\"", ",", "\"\<//\>\"", ",", 
                "\"\<OAc SA & dNAc SA\>\"", ",", "\"\<Bx-ions\>\"", " ", ",", 
                "\"\<Y-ions\>\"", ",", "\"\<Z-ions\>\""}], "}"}]}], "]"}], 
            ",", "\"\<XLS\>\""}], "]"}], "]"}], "]"}]}], "}"}], ",", 
      RowBox[{"WindowTitle", "\[Rule]", "\"\<FileSave\>\""}]}], "]"}], ";"}], 
   ",", 
   RowBox[{"Method", "\[Rule]", "\"\<Queued\>\""}]}], "]"}]], "Input",
 Editable->False,
 CellOpen->False],

Cell[BoxData[
 ButtonBox["\<\"Save Results\"\>",
  Appearance->Automatic,
  ButtonFunction:>(CreateDialog[{
      TextCell["Enter a name: "], 
      InputField[
       Dynamic[$CellContext`name], String], 
      TextCell["Select a folder: "], 
      FileNameSetter[
       Dynamic[$CellContext`folder], "Directory"], 
      DefaultButton[
       DialogReturn[
        Export[
         ToString[($CellContext`folder $CellContext`name) ".xls"], 
         Prepend[
          SortBy[$CellContext`dataD1, {
            Part[#, 6], -Part[#, 1], -Part[#, 4]}& ], {
          "N-total", "N(OAc SA & dNAc SA)", "N(Bx-ions)", "N(Y-ions)", 
           "N(Z-ions)", "Experimental mass", "Theoretical mass", "Delta", 
           "GSL", "//", "OAc SA & dNAc SA", "Bx-ions", "Y-ions", "Z-ions"}], 
         "XLS"]]]}, WindowTitle -> "FileSave"]; Null),
  Evaluator->Automatic,
  Method->"Queued"]], "Output"]
}, {2}]]
},
WindowSize->{819, 895},
WindowMargins->{{107, Automatic}, {13, Automatic}},
TrackCellChangeTimes->False,
FrontEndVersion->"8.0 for Microsoft Windows (64-bit) (February 23, 2011)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[557, 20, 45, 0, 52, "Input"],
Cell[CellGroupData[{
Cell[627, 24, 2136, 51, 19, "Input",
 CellOpen->False],
Cell[2766, 77, 904, 20, 42, "Output"]
}, {2}]],
Cell[3682, 100, 26, 0, 31, "Input"],
Cell[CellGroupData[{
Cell[3733, 104, 852, 22, 19, "Input",
 CellOpen->False],
Cell[4588, 128, 4004, 81, 206, "Output"]
}, {2}]],
Cell[8604, 212, 26, 0, 31, "Input"],
Cell[CellGroupData[{
Cell[8655, 216, 481, 13, 19, "Input",
 CellOpen->False],
Cell[9139, 231, 274, 7, 42, "Output"]
}, {2}]],
Cell[9425, 241, 45, 0, 52, "Input"],
Cell[CellGroupData[{
Cell[9495, 245, 8160, 204, 19, "Input",
 CellOpen->False],
Cell[17658, 451, 24369, 444, 691, "Output"]
}, {2}]],
Cell[42039, 898, 26, 0, 31, "Input"],
Cell[CellGroupData[{
Cell[42090, 902, 70406, 1601, 19, "Input",
 CellOpen->False],
Cell[112499, 2505, 24568, 579, 42, "Output"]
}, {2}]],
Cell[137079, 3087, 26, 0, 31, "Input"],
Cell[CellGroupData[{
Cell[137130, 3091, 262, 8, 19, "Input",
 CellOpen->False],
Cell[137395, 3101, 118, 2, 33, "Output"]
}, {2}]],
Cell[137525, 3106, 26, 0, 31, "Input"],
Cell[CellGroupData[{
Cell[137576, 3110, 3244, 104, 19, "Input",
 CellOpen->False],
Cell[140823, 3216, 1882, 34, 42, "Output"]
}, {2}]],
Cell[142717, 3253, 26, 0, 31, "Input"],
Cell[CellGroupData[{
Cell[142768, 3257, 2362, 53, 19, "Input",
 CellOpen->False],
Cell[145133, 3312, 893, 22, 42, "Output"]
}, {2}]]
}
]
*)

(* End of internal cache information *)
